<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package WordPress
 * @subpackage hostiko
 * @since 1.0
 * @version 1.0
 */

get_header(); 
ob_start(); // start capturing output.
				do_action('get_page_404');
				$page404_content = ob_get_contents(); // the actions output will now be stored in the variable as a string!
				ob_end_clean();
				if(empty($page404_content))
				{
					
?>


<div class="wrap">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

			<section class="error-404 not-found">
				<header class="page-header">
					<h1 class="page-title"><?php _e( 'Oops! That page can&rsquo;t be found.', 'hostiko' ); ?></h1>
				</header><!-- .page-header -->
				<div class="page-content">
					<p><?php _e( 'It looks like nothing was found at this location. Maybe try a search?', 'hostiko' ); ?></p>

					<?php get_search_form(); ?>

				</div><!-- .page-content -->
			</section><!-- .error-404 -->
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrap -->

<?php
				}
				else
				{
					do_action('get_page_404');
					
				}
get_footer();
