<?php

namespace ElementPress\Modules\Header_Footer\Theme_Hooks;

defined('ABSPATH') || exit;

class Theme_Support
{

    function __construct($template_ids)
    {
        add_action('elementpress/template/header', [$this, 'get_header'], 2);
        add_action('elementpress/template/footer', [$this, 'get_footer'], 1000);
		add_action('elementpress/template/header_no', [$this, 'get_header_no'], 2);
		   add_action('elementpress/template/footer_no', [$this, 'get_footer_no'], 1000);

        if ($template_ids[0] != null) {
//              add_filter( 'template_include', array( $this, 'get_header' ), 2 );
             add_action('get_header', [$this, 'get_header']);
        }
        if ($template_ids[1] != null) {
            // add_filter( 'template_include', array( $this, 'get_footer' ), 2 );
            //  get_header
             add_action('get_footer', [$this, 'get_footer']);
        }
        if ($template_ids[2] != null && is_single()) {

            // add_filter( 'get_single', array( $this, 'get_single' ), 999 );
            add_filter('template_include', array($this, 'get_single'), 2);

        }

        if ($template_ids[3] != null && is_archive()) {
            add_filter('template_include', array($this, 'get_archive'), 4);
            //add_filter( 'get_archive', array( $this, 'get_archive' ), 999 );

        }

        if ($template_ids[4] != null && is_404()) {

            add_filter('template_include', array($this, 'get_page_404'), 4);

        }

        if ($template_ids[5] != null) {
add_filter('template_include', array($this, 'ng_maintenance_mode'), 4);
//             SELF::ng_maintenance_mode($template_ids[5]);

        }

        if ($template_ids[6] != null && is_search()) {
            add_filter('template_include', array($this, 'get_search'), 4);
        }

        if ($template_ids[7] != null && is_home()) {
            add_filter('template_include', array($this, 'get_blog'), 4);

//              add_filter( 'get_blog', array( $this, 'get_blog' ), 999 );

        }
    }


    public function get_header($name)
    {
        require __DIR__ . '/../views/theme-support-header.php';

        $templates = array();

        $name = (string)$name;

        if ('' !== $name) {

            $templates[] = "header-{$name}.php";

        }
        $templates[] = 'header.php';
        remove_all_actions('wp_head');
        ob_start();
        locate_template($templates, true, true);

        ob_get_clean();
    }

    public function get_footer($name)
    {
        require __DIR__ . '/../views/theme-support-footer.php';

        $templates = [];

        $name = (string)$name;

        if ('' !== $name) {

            $templates[] = "footer-{$name}.php";

        }
        $templates[] = 'footer.php';
	
        ob_start();
        locate_template($templates, true);

        ob_get_clean();
		
    }

		public function get_header_no($name)
    {
        require __DIR__ . '/../views/theme-support-header-no.php';

        $templates = array();

        $name = (string)$name;

        if ('' !== $name) {

            $templates[] = "header-{$name}.php";

        }
        $templates[] = 'header.php';
        remove_all_actions('wp_head');
        ob_start();
        locate_template($templates, true, true);

        ob_get_clean();
    }
	
	  public function get_footer_no($name)
    {
        require __DIR__ . '/../views/theme-support-footer-no.php';

        $templates = [];

        $name = (string)$name;

        if ('' !== $name) {

            $templates[] = "footer-{$name}.php";

        }
        $templates[] = 'footer.php';
        ob_start();
        locate_template($templates, true);

        ob_get_clean();
    }
	
	
	
	
	
    public function get_single($name)
    {

        require __DIR__ . '/../views/theme-support-single.php';
        /*$templates = [];

                $name = (string) $name;

                if ( '' !== $name ) {

                    $templates[] = "single-{$name}.php";

                }

                $templates[] = 'single.php';

                ob_start();

                // It cause a `require_once` so, in the get_header it self it will not be required again.

                locate_template( $templates, true );
        *
                ob_get_clean();*/

    }

    public function get_archive($name)
    {

        require __DIR__ . '/../views/theme-support-archive.php';


    }

    public function get_page_404($name)
    {

        require __DIR__ . '/../views/theme-support-404.php';
die();
    }

    public function ng_maintenance_mode($template_ids = null)
    {

        global $pagenow;

        if ($pagenow !== 'wp-login.php' && !current_user_can('manage_options') && !is_admin()) {

            require __DIR__ . '/../views/theme-support-maintenance.php';

//             $templates[] = "maintenance.php";

//             locate_template($templates, true, true);

            die();

        }

    }

    public function get_search($name)
    {
        require __DIR__ . '/../views/theme-support-search.php';
    }

    public function get_blog($name)
    {

        require __DIR__ . '/../views/theme-support-blog.php';
		
    }
}