<?php


namespace ElementPress\Modules\Epress_Forms;


use Elementor\Plugin;
use Elementor\Core\Base\Module;

defined('ABSPATH') || exit;

class Init extends Module
{

    public $dir;

    public $url;

    public function __construct()
    {

        // get current directory path
        $this->dir = dirname(__FILE__) . '/';

        // get current module's url
        $this->url = \ElementPress::plugin_url() . 'modules/epress-forms/';
        add_action('elementor/widgets/widgets_registered', [$this, 'forms_widgets']);

        // enqueue scripts
        add_action('elementor/frontend/before_enqueue_scripts', [$this, 'enqueue_styles']);
        add_action('elementor/frontend/before_enqueue_scripts', [$this, 'enqueue_scripts']);

        add_action('wp_ajax_submit_form', [$this, 'submit_form']);
        add_action('wp_ajax_nopriv_submit_form', [$this, 'submit_form']);
    }

    public function get_name()
    {
        return 'forms';
    }

    public function get_widgets()
    {
        return [
           'Forms',
        ];
    }

    public function forms_widgets()
    {

        $widget_manager = Plugin::$instance->widgets_manager;

        foreach ($this->get_widgets() as $widget) {
            $class_name = $this->get_reflection()->getNamespaceName() . '\widgets\\' . $widget;
            //echo 'class_name'.print_r($class_name,true).'<br>';
            $widget_manager->register_widget_type(new $class_name());
        }
    }

    public function submit_form()

    {
        $receiver_email='';
        $email_subject='';
        $count=0;
        $body = '';
        $body .= '<table>';
        $body.='<tr>';
 if ($_POST['fileds']) {
            $fields = explode('&', $_POST['fileds']);
            echo "<pre>".print_r($fields)."<br>";
            foreach ($fields as $k => $v) {
                if ($count > 3) {
                    if ($v !== 'form_id=2fad637') {
                        $body .= '<td>';
                        $body .= ' ' . $v . ' ';
                        $body .= '</td>';
                    }
                }
                $count++;
            }
        }
        $body.='</tr>';
        $body .= '</table>';


        parse_str($_POST["fileds"], $_POST);
        if(isset($_POST['reciver_email']) && $_POST['reciver_email'] !=""){
            $receiver_email=$_POST['reciver_email'];
        }
        else {
            $receiver_email= get_option('admin_email');

        }

        if(isset($_POST['email_subject']) && $_POST['email_subject'] !=""){
        $email_subject=$_POST['email_subject'];
    }
    else {
        $email_subject= 'Contact Query';
    }


        $sitename= get_bloginfo();
        $headers[] = 'Content-Type: text/html; charset=UTF-8';
        $headers[] = 'From:'. $sitename. '<'.$receiver_email.'>' . "\r\n";


        if(wp_mail($receiver_email, $email_subject, $body,$headers)){
            wp_send_json_success(__('Thanks for Your Email!', 'reportabug'));
        }
        else{
            wp_send_json_error(__('Thanks for reporting!', 'reportabug'));
        }

    }


    public function enqueue_styles()
    {
        wp_enqueue_style('forms-css', $this->url . 'assets/css/forms.css', false, \ElementPress::version);
    }

    public function enqueue_scripts()
    {

        wp_enqueue_script('validator-js', $this->url . '/assets/js/validator.js', false, \ElementPress::version);
        wp_enqueue_script('forms-js', $this->url . 'assets/js/forms.js', false, \ElementPress::version);
        wp_localize_script('forms-js', 'settings', array('ajaxurl' => admin_url('admin-ajax.php'), 'send_label' => __('Submit Forms', 'submitform')));

    }

    public static function is_form_submitted()
    {
        return wp_doing_ajax() && isset($_POST['action']) && 'element_press_forms_send_form' === $_POST['action'];
    }
}