<?php
namespace ElementPress;

defined( 'ABSPATH' ) || exit;


/**
 * elementpress - the God class.
 * Initiate all necessary classes, hooks, configs.
 *
 * @since 1.1.0
 */
class Handler{


	/**
	 * The plugin instance.
	 *
	 * @since 1.0.0
	 * @access public
	 * @static
	 *
	 * @var Handler
	 */
    public static $instance = null;

    /**
     * Construct the plugin object.
     *
     * @since 1.0.0
     * @access public
     */
    public function __construct() {

        // Call the method for elementpress autoloader.
        $this->registrar_autoloader();
        add_action( 'admin_enqueue_scripts', [$this, 'enqueue_admin'] );
        
        Core\Build_Inline_Scripts::instance();
    
        Admin\Attr::instance();
    
        Core\Build_Modules::instance();

        // Register elementpress's custom endpoints for WP RESTful APIs and 3rd party hooks.
        add_action( 'init', [$this, 'register_apis'],  1055);
    }
    public function enqueue_admin(){
        $screen = get_current_screen();
        // dd($screen);
        if(!in_array($screen->id, ['nav-menus', 'toplevel_page_elementpress', 'edit-elementpresstemplate', 'elementpress_page_elementpress-license'])){
            return;
        }
        wp_register_style( 'elementpress-lib-css-admin', \ElementPress::lib_url() . 'framework/assets/css/framework.css', \ElementPress::version );
        wp_register_style( 'elementpress-init-css-admin', \ElementPress::lib_url() . 'framework/assets/css/admin-style.css', \ElementPress::version );
        wp_register_style( 'elementpress-init-css-admin-ems', \ElementPress::lib_url() . 'framework/assets/css/admin-style-ems-dev.css', \ElementPress::version );
        wp_enqueue_style( 'elementpress-font-css-admin' );
        wp_enqueue_style( 'elementpress-init-css-admin' );
        wp_enqueue_style( 'elementpress-init-css-admin-ems' );
        wp_enqueue_script( 'bootstrap', \ElementPress::lib_url() . 'framework/assets/js/bootstrap.min.js', \ElementPress::version, true );
        wp_enqueue_script( 'popper', \ElementPress::lib_url() . 'framework/assets/js/popper.min.js', \ElementPress::version, true );
        wp_enqueue_script( 'elementpress-init-js-admin', \ElementPress::lib_url() . 'framework/assets/js/admin-script.js', \ElementPress::version, true );
    }

    public function register_apis(){
        new Core\Build_Apis();
    }

    private function registrar_autoloader() {
        require_once \ElementPress::plugin_dir() . '/autoloader.php';
        Autoloader::run();
    }


    public static function instance() {
        if ( is_null( self::$instance ) ) {

            // Fire when elementpress instance.
            self::$instance = new self();

        }

        return self::$instance;
    }
}

//Run the instance.
Handler::instance();