<?php
namespace Elementor;
use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;
class Elementpress_Widget_sharepost extends Widget_Base {
	public $base;
		public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	

		wp_register_style( 'elementpress-css-icon-control-share',  \ElementPress::module_url() . 'controls/assets/css/epressicons.css', [], '1.0.1' );


	 }

	  public function get_style_depends() {
		 
		 return ['elementpress-css-icon-control-share' ];
	  }
    public function get_name() {
        //get name from sharepost-handler.php file
        return 'elementpress-social-share';
    }
    public function get_title() {
         //get title from sharepost-handler.php file
         return esc_html__( 'Share Post', 'elementpress' );
    }
    public function get_icon() {
         //get icon from sharepost-handler.php file
         return ' eicon-social-icons epress-widget-icon';
    }
    public function get_categories() {
         //get categories from sharepost-handler.php file
         return [ 'elementpress_singlepost' ];
    }
    protected function register_controls() {
        // start content section for social media
        //single post social media section
        $this->start_controls_section(
            'epress_socialshare_section_tab_content',
            [
                'label' => esc_html__('Single Post Social Media', 'elementpress'),
            ]
        );
        //controls for single post media section
        //select box control inside single post social media section
        $this->add_control(
			'epress_socialshare_style',
			[
				'label' => esc_html__( 'Choose Style', 'elementpress' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'icon',
				'options' => [
					'icon'  => esc_html__( 'Icon', 'elementpress' ),
					'text' => esc_html__( 'Text', 'elementpress' ),
					'both' => esc_html__( 'Both', 'elementpress' ),
				],
			]
        );
         //select box control for icon  inside single post social media section
        $this->add_control(
			'epress_socialshare_style_icon_position',
			[
				'label' => esc_html__( 'Icon Position', 'elementpress' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'before', //default option before selected
				'options' => [
					'before'  => esc_html__( 'Before', 'elementpress' ),
					'after' => esc_html__( 'After', 'elementpress' ),
                ],
                'condition' => [
                    'epress_socialshare_style' => 'both' //show only if both is selected from choose style option
                ]
			]
        );
         //slider control for varying spacing right
        $this->add_responsive_control(
			'epress_socialshare_icon_padding_right',
			[
				'label' => esc_html__( 'Spacing Right', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} a > i' => 'padding-right: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_socialshare_style' => 'both', //show only if both is selected from choose style option
                    'epress_socialshare_style_icon_position' => 'before', //show only if before is selected from icon position option
                ]
			]
        );
        //slider control for varying spacing left
        $this->add_responsive_control(
			'epress_socialshare_icon_padding_left',
			[
				'label' => esc_html__( 'Spacing Left', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} a > i' => 'padding-left: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_socialshare_style' => 'both', //show only if both is selected from choose style option
                    'epress_socialshare_style_icon_position' => 'after', //show only if after is selected from icon position option
                ]
			]
        );
        //alignment choose control
        $this->add_responsive_control(
            'epress_socialshare_list_align',
            [
                'label' => esc_html__( 'Alignment', 'elementpress' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementpress' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementpress' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementpress' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
				'selectors' => [
                    '{{WRAPPER}} .epress_socialshare' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		$socialshare = new Repeater();
        // set social icon
        //icon control tpo choose different icons
        $socialshare->add_control(
            'epress_socialshare_icon',
            [
                'label' => esc_html__( 'Icon', 'elementpress' ),
                'label_block' => true,
                'type' => Controls_Manager::ICON,
                'default' => 'icon icon-facebook',
            ]
        );
        // set social link
        //select box to choose different social media platforms
        $socialshare->add_control(
            'epress_socialshare_label_text',
            [
                'label' => __( 'Social Media', 'elementpress' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'facebook',
                'options' => [
                    'facebook'      => __( 'Facebook', 'elementpress' ),
                    'twitter'       => __( 'Twitter', 'elementpress' ),
                    'instagram'    => __( 'Instagram', 'elementpress' ),
                    'pinterest'     => __( 'Pinterest', 'elementpress' ),
                    'linkedin'      => __( 'Linkedin', 'elementpress' ),
                    'tumblr'        => __( 'Tumblr', 'elementpress' ),
                    'snapchat'        => __( 'Snapchat', 'elementpress' ),
                    'flicker'        => __( 'Flicker', 'elementpress' ),
                    'vkontakte'     => __( 'Vkontakte', 'elementpress' ),
                    'odnoklassniki' => __( 'Odnoklassniki', 'elementpress' ),
                    'moimir'        => __( 'Moimir', 'elementpress' ),
                    'live journal'   => __( 'Live journal', 'elementpress' ),
                    'blogger'       => __( 'Blogger', 'elementpress' ),
                    'digg'          => __( 'Digg', 'elementpress' ),
                    'evernote'      => __( 'Evernote', 'elementpress' ),
                    'reddit'        => __( 'Reddit', 'elementpress' ),
                    'delicious'     => __( 'Delicious', 'elementpress' ),
                    'stumbleupon'   => __( 'Stumbleupon', 'elementpress' ),
                    'pocket'        => __( 'Pocket', 'elementpress' ),
                    'surfingbird'   => __( 'Surfingbird', 'elementpress' ),
                    'liveinternet'  => __( 'Liveinternet', 'elementpress' ),
                    'buffer'        => __( 'Buffer', 'elementpress' ),
                    'instapaper'    => __( 'Instapaper', 'elementpress' ),
                    'xing'          => __( 'Xing', 'elementpress' ),
                    'wordpress'     => __( 'WordPress', 'elementpress' ),
                    'baidu'         => __( 'Baidu', 'elementpress' ),
                    'renren'        => __( 'Renren', 'elementpress' ),
                    'weibo'         => __( 'Weibo', 'elementpress' ),
                    'skype'         => __( 'Skype', 'elementpress' ),
                    'telegram'      => __( 'Telegram', 'elementpress' ),
                    'viber'         => __( 'Viber', 'elementpress' ),
                    'whatsapp'      => __( 'Whatsapp', 'elementpress' ),
                    'line'          => __( 'Line', 'elementpress' ),
                ],
            ]
        );
		// set social icon text
        $socialshare->add_control(
            'epress_socialshare_label',
            [
                'label' => esc_html__( 'Label', 'elementpress' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		// start tab for content
		$socialshare->start_controls_tabs(
            'epress_socialshare_tabs'
        );
		// start normal tab
        $socialshare->start_controls_tab(
            'epress_socialshare_normal',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
        );
        // set social icon color
        //color picker for social icon
        $socialshare->add_responsive_control(
			'epress_socialshare_icon_color',
			[
				'label' =>esc_html__( 'Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} > a' => 'color: {{VALUE}};',
				],
			]
		);
		// set social icon background color
        $socialshare->add_responsive_control(
			'epress_socialshare_icon_bg_color',
			[
				'label' =>esc_html__( 'Background Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} > a' => 'background-color: {{VALUE}};', //css selector to apply value to specific class
				],
			]
        );
        //border control
        $socialshare->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'epress_socialshare_border',
				'label' => esc_html__( 'Border', 'elementpress' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} > a',
			]
        );
        //text shadow control
         $socialshare->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'epress_socialshare_icon_normal_text_shadow',
				'label' => esc_html__( 'Text Shadow', 'elementpress' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} > a',
			]
        );
        $socialshare->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name'       => 'epress_socialshare_list_box_shadow',
                'selector'   => '{{WRAPPER}} {{CURRENT_ITEM}} > a',
            ]
        );
		$socialshare->end_controls_tab();
		// end normal tab
		//start hover tab
		$socialshare->start_controls_tab(
            'epress_socialshare_hover',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
        );
		// set social icon color
        $socialshare->add_responsive_control(
			'epress_socialshare_icon_hover_color',
			[
				'label' =>esc_html__( 'Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} > a:hover' => 'color: {{VALUE}};',
				],
			]
		);
		// set social icon background color
        $socialshare->add_responsive_control(
			'epress_socialshare_icon_hover_bg_color',
			[
				'label' =>esc_html__( 'Background Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#3b5998',
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} > a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$socialshare->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'epress_socialshare_icon_hover_text_shadow',
				'label' => esc_html__( 'Text Shadow', 'elementpress' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} > a:hover',
			]
        );
        $socialshare->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name'       => 'epress_socialshare_list_box_shadow_hover',
                'selector'   => '{{WRAPPER}} {{CURRENT_ITEM}} > a:hover',
            ]
        );
        $socialshare->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'epress_socialshare_border_hover',
				'label' => esc_html__( 'Border', 'elementpress' ),
				'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} > a:hover',
			]
		);
		$socialshare->end_controls_tab();
		//end hover tab
		$socialshare->end_controls_tabs();
		// set social icon add new control
        $this->add_control(
            'epress_socialshare_add_icons',
            [
                'label' => esc_html__('Add Social Media', 'elementpress'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $socialshare->get_controls(),
                'default' => [
                    [
                        'epress_socialshare_icon' => 'icon icon-facebook',
                        'epress_socialshare_icon_hover_bg_color' => '#3b5998',
                        'epress_socialshare_label_text' => 'facebook',
                    ],
					[
                        'epress_socialshare_icon' => 'icon icon-twitter',
                        'epress_socialshare_icon_hover_bg_color' => '#1da1f2',
                        'epress_socialshare_label_text' => 'twitter',
                    ],
					[
                        'epress_socialshare_icon' => 'icon icon-linkedin',
                        'epress_socialshare_icon_hover_bg_color' => '#0077b5',
                        'epress_socialshare_label_text' => 'linkedin',
                    ],
                ],
                'title_field' => '{{{ epress_socialshare_label_text }}}',
            ]
        );
		$this->end_controls_section();
		// end content section
	// start style section control
		// start Social media tab
		 $this->start_controls_section(
            'epress_socialshare_section_tab_style',
            [
                'label' => esc_html__('Single Post Social Media', 'elementpress'),
				 'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
		// Alignment
        $this->add_responsive_control(
            'epress_socialshare_list_item_align',
            [
                'label' => esc_html__( 'Alignment', 'elementpress' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementpress' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementpress' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementpress' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
				'selectors' => [
                    '{{WRAPPER}} .epress_socialshare > li > a' => 'text-align: {{VALUE}};',
                ],
            ]
        );
		// Display design
		 $this->add_responsive_control(
            'epress_socialshare_list_display',
            [
                'label' => esc_html__( 'Display', 'elementpress' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'inline-block',
                'options' => [
                    'inline-block' => esc_html__( 'Inline Block', 'elementpress' ),
                    'block' => esc_html__( 'Block', 'elementpress' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .epress_socialshare > li' => 'display: {{VALUE}};',
                ],
            ]
        );
		// text decoration
		 $this->add_responsive_control(
            'epress_socialshare_list_decoration_box',
            [
                'label' => esc_html__( 'Decoration', 'elementpress' ),
                'type' => Controls_Manager::SELECT,
				'default' => 'none',
                'options' => [
                    'none' => esc_html__( 'None', 'elementpress' ),
                    'underline' => esc_html__( 'Underline', 'elementpress' ),
                    'overline' => esc_html__( 'Overline', 'elementpress' ),
                    'line-through' => esc_html__( 'Line Through', 'elementpress' ),
                ],
                'selectors' => ['{{WRAPPER}} .epress_socialshare > li > a' => 'text-decoration: {{VALUE}};'],
            ]
        );
		// border radius
		 $this->add_responsive_control(
            'epress_socialshare_list_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '50',
					'right' => '50',
					'bottom' => '50' ,
					'left' => '50',
					'unit' => '%',
				],
                'selectors' => [
                    '{{WRAPPER}} .epress_socialshare > li > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		// Padding style
		 $this->add_responsive_control(
            'epress_socialshare_list_padding',
            [
                'label'         => esc_html__('Padding', 'elementpress'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em'],
				'default' => [
					'top' => '6',
					'right' => '7',
					'bottom' => '6' ,
					'left' => '7',
				],
                'selectors' => [
                    '{{WRAPPER}} .epress_socialshare > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		// margin style
		$this->add_responsive_control(
            'epress_socialshare_list_margin',
            [
                'label'         => esc_html__('Margin', 'elementpress'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em'],
				'default' => [
					'top' => '5',
					'right' => '5',
					'bottom' => '5' ,
					'left' => '5',
				],
                'selectors' => [
                    '{{WRAPPER}} .epress_socialshare > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'epress_socialshare_list_typography',
				'label' => esc_html__( 'Typography', 'elementpress' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .epress_socialshare > li > a',
			]
		);
        $this->add_control(
			'epress_socialshare_list_style_use_height_and_width',
			[
				'label' => esc_html__( 'Use Height Width', 'elementpress' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'elementpress' ),
				'label_off' => esc_html__( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        $this->add_responsive_control(
			'epress_socialshare_list_width',
			[
				'label' => esc_html__( 'Width', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .epress_socialshare > li > a' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_socialshare_list_style_use_height_and_width' => 'yes'
                ]
			]
		);
        $this->add_responsive_control(
			'epress_socialshare_list_height',
			[
				'label' => esc_html__( 'Height', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .epress_socialshare > li > a' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_socialshare_list_style_use_height_and_width' => 'yes'
                ]
			]
		);
        $this->add_responsive_control(
			'epress_socialshare_list_line_height',
			[
				'label' => esc_html__( 'Line Height', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .epress_socialshare > li > a' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_socialshare_list_style_use_height_and_width' => 'yes'
                ]
			]
		);
    }
    protected function render( ) {
        echo '<div class="epress-wid-con" >';
            $this->render_raw();
        echo '</div>';
    }
    protected function render_raw( ) {
        $settings = $this->get_settings();
        // echo "<pre>";
        // echo print_r($settings);
        // die;
        extract($settings);
		?>
		<ul class="epress_socialshare" id="flex_post">
            <?php foreach ($epress_socialshare_add_icons as $icon): ?>
                <?php if($icon['epress_socialshare_icon'] != ''): ?>
                <li class="elementor-repeater-item-<?php echo esc_attr( $icon[ '_id' ] ); ?>" data-social="<?php echo esc_attr((preg_replace('/[#$%^&*()+=\-\[\]\';,.\/{}|":<>?~\\\\ ]/', '', strtolower($icon['epress_socialshare_label_text']))))?>">
                    <a class="<?php echo esc_attr((preg_replace('/[#$%^&*()+=\-\[\]\';,.\/{}|":<>?~\\\\ ]/', '', strtolower($icon['epress_socialshare_label_text']))))?>">
                        <?php if($settings['epress_socialshare_style'] != 'text' && $settings['epress_socialshare_style_icon_position'] == 'before'): ?>
                        <i class="<?php echo esc_attr( $icon['epress_socialshare_icon'] ); ?>"></i>
                        <?php endif; ?>
                        <?php if($settings['epress_socialshare_style'] != 'icon' ): ?>
                        <?php if ($icon['epress_socialshare_label'] == '') : ?>
                        <?php echo esc_html((preg_replace('/[#$%^&*()+=\-\[\]\';,.\/{}|":<>?~\\\\]/', ' ', ucwords($icon['epress_socialshare_label_text']))), 'elementpress')?>
                        <?php else : ?>
                        <?php echo esc_html($icon['epress_socialshare_label'], 'elementpress')?>
                        <?php endif; ?>
                        <?php endif; ?>
                        <?php if($settings['epress_socialshare_style'] != 'text' && $settings['epress_socialshare_style_icon_position'] == 'after'): ?>
                        <i class="<?php echo esc_attr( $icon['epress_socialshare_icon'] ); ?>"></i>
                        <?php endif; ?>
                    </a>
                </li>
                <?php endif; ?>
            <?php endforeach; ?>
        </ul>
        <?php
    }
    protected function content_template() { }
}