<?php
namespace Elementor;
use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;
class Elementpress_Widget_postcontent extends Widget_Base {
	public $base;
    public function get_name() {
		//get name from postcontent-handler file
		return 'elementpress-postcontent';
    }
    public function get_title() {
		//get title from postcontent-handler file
		return esc_html__( 'Post Content', 'elementpress' );
    }
    public function get_icon() {
		//get icon from postcontent-handler file
		return 'eicon-post-content';
    }
    public function get_categories() {
		//get categories from postcontent-handler file
        return [ 'elementpress_singlepost' ];
	}
	//default elementor function to register and build controls
    protected function register_controls() {
		//single post content section
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Single Post Content', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//text align control inside single post content section
        $this->add_control(
			'title_align',
			[
				'label' => __( 'Alignment', 'elementpress' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'elementpress' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'elementpress' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'elementpress' ),
						'icon' => 'eicon-text-align-right',
					],
					
				],
				'default' => 'left',
				'selectors' => [
					'{{WRAPPER}} .post_content p' => 'text-align: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section(); //end first section
		//style section after single post content section.
        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//typography control inside style section.
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'elementpress' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .post_content p', //adding this control to p tag having class .post_content in render function
			]
        );
         //Color picker control inside style section
         $this->add_control(
        	'title_color',
        	[
        		'label' => __( 'Title Color Text', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
        	'default' => '#000',
        		'selectors' => [
        			'{{WRAPPER}} .post_content p' => 'color: {{VALUE}}', //adding this control to p tag having class .post_content in render function
        		],
        	]
        );
        $this->end_controls_section();
	}
	//front end display
    protected function render() {

if($this->is_on_editor()){
	ob_start();
?>
<div class="post_content">
<p><span class="dropcap">D</span>ropcap the popularization of the “ideal measure” has led to advice such as “Increase font size for large screens and reduce font size for small screens.” While a good measure does improve the reading experience, it’s only one rule for <a href=\"#\">good typography</a>. Another rule is to maintain a comfortable font size. </p><p>Strech lining hemline above knee burgundy glossy silk complete hid zip little catches rayon. Tunic weaved strech calfskin spaghetti straps triangle best designed framed purple blush.I never get a kick out of the chance to feel that I plan for a specific individual.</p><p>Separated they live in Bookmarksgrove right at the coast of the <a href=\"#\">Semantics</a>, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.</p><p>A wonderful serenity has taken <strong>possession</strong> of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. Even the all-powerful Pointing has no control about the blind texts it is an almost <a href=\"#\">unorthographic</a> life One day however a small line of blind text by the name of<strong> Lorem Ipsum</strong> decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p><blockquote class=\"pullquote align-center\"><p>The will to win, the desire to succeed, the urge to reach your full potential these are the keys that will unlock the door to personal excellence.</p></blockquote><p>One morning, when <strong>Gregor Samsa</strong> woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his <em>armour-like</em> back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections.</p><p>A wonderful serenity has taken <strong>possession</strong> of my entire soul, like these sweet mornings of spring which I enjoy with my whole heart. Even the all-powerful Pointing has no control about the blind texts it is an almost <a href=\"#\">unorthographic</a> life One day however a small line of blind text by the name of<strong> Lorem Ipsum</strong> decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</p><p>His room, a proper human room although a little too small, lay peacefully between its four familiar walls. A collection of textile samples lay spread out on the table – Samsa was a travelling salesman – and above it there hung a picture that he had recently cut out of an illustrated magazine and housed in a nice, gilded frame.</p><p>It showed a lady fitted out with a fur hat and fur boa who sat upright, raising a heavy fur muff that covered the whole of her lower arm towards the viewer. Gregor then turned to look out the window at the dull weather. Drops of rain could be heard hitting the pane, which made him feel quite sad.</p>
</div>
<?php
$content=ob_get_clean();
echo $content;

}
else {
			
			$settings = $this->get_settings_for_display();
		$queried_object = get_queried_object();
		if ( $queried_object ) {
			$post_id = $queried_object->ID;
		
		}
		$post = get_post($post_id); // specific post
		$the_content = apply_filters('the_content', $post->post_content);
		if ( !empty($the_content)) {
			?>
			<div class="post_content">
				<?php echo $the_content; ?>
			</div>
		<?php
		}
            // return $this->render_module_front($attr, $column_class);
        }



	

	}
	public function is_on_editor() {

        if ( function_exists('jeg_is_frontend_vc') && jeg_is_frontend_vc() )
            return true;

        if ( isset( $_REQUEST['action'] ) ) {

            if ( ( $_REQUEST['action'] === 'elementor' || $_REQUEST['action'] === 'elementor_ajax' ) )
                return true;
        }

        return false;
    }
    protected function content_template() { }
}