<?php
namespace Elementor;
use \Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;
class Elementpress_Widget_featuredvspslider extends Widget_Base {

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);

		wp_register_script( 'featured-jquery-ui-vps', \ElementPress::widgets_url() .'/featured-vpsslider/assets/js/jquery-ui.js', array( 'jquery' ), \ElementPress::version, true );
		wp_register_script( 'featured-touch-punch-vps',  \ElementPress::widgets_url() .'/featured-vpsslider/assets/js/touch-punch.js', array( 'jquery' ), \ElementPress::version, true);
		wp_register_script( 'featured-slider_setting-vps',  \ElementPress::widgets_url() .'/featured-vpsslider/assets/js/slider_setting.js', array( 'jquery' ), \ElementPress::version, true );

		wp_enqueue_style( 'featured-vps-slidercss-vps',  \ElementPress::widgets_url() . '/featured-vpsslider/assets/css/vps-slider.css', false, \ElementPress::version );
		wp_enqueue_style( 'featured-vps-priceslidercss-vps', \ElementPress::widgets_url() . '/featured-vpsslider/assets/css/priceslider.css', false, \ElementPress::version );
		add_action( 'wp_print_styles', array( $this, 'register_widget_styles' ) );

		// wp_register_style( 'vps-slidercss-vps',  \ElementPress::widgets_url() . '/featured-vpsslider/assets/css/vps-slider.css', false, \ElementPress::version );
		// wp_register_style( 'vps-priceslidercss-vps', \ElementPress::widgets_url() . '/featured-vpsslider/assets/css/priceslider.css', false, \ElementPress::version );


	 }
	 public function register_widget_styles(){
	 }
	 public function get_script_depends() {
		
		 return [ 'jquery-ui-vps','touch-punch-vps','slider_setting-vps' ];
	  }
  
	//   public function get_style_depends() {
		 
	// 	 return [ 'vps-priceslidercss-vps','vps-slidercss-vps' ];
	//   }
    public function get_name() {
		//get widget name from vpslider-handler.php file
		return 'elementpress-featuredvspslider';
    }
    public function get_title() {
		//get widget title from vpslider-handler.php file
        return esc_html__( 'Featured Vps Slider', 'elementpress' );
    }
    public function get_icon() {
		//get widget icon from vpslider-handler.php file
		return 'eicon-slider-3d';
    }
    public function get_categories() {
		//get widget category from vpslider-handler.php file
        return [ 'additional-addons' ];
	}
	//register controls
    protected function register_controls() {
		//Vps slider content section inside vps slider widget
        $this->start_controls_section(
			'content_section',
			[
				'label' => __('Vps Slider', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
        );

        
	//currency text control inside Vps slider content section
        $this->add_control(
			'currency',
			[
				'label' => __( 'Enter You Currency', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$', 'elementpress' ),
				'placeholder' => __( 'Enter Your Currency Symbol', 'elementpress' ),
			]
		);

        $this->add_control(
            'defualt_position',
            [
                'label' => __( 'Enter You Default Position', 'elementpress' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( '1', 'elementpress' ),
            ]
        );
		// button text control inside Vps slider content section
        $this->add_control(
			'btn_txt',
			[
				'label' => __( 'Order Button Text', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Order Now', 'elementpress' ),
				'placeholder' => __( 'Enter Your Custom Order Button Text', 'elementpress' ),
			]
		);
		//price period control inside Vps slider content section
        $this->add_control(
			'period_text',
			[
				'label' => __( 'Enter Your price period', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'mo', 'elementpress' ),
				'placeholder' => __( 'Enter Your price period', 'elementpress' ),
			]
		);
		$this->add_control(
			'period_separator',
				[
					'label' => __( 'Enter Your price separator', 'elementpress' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => __( '/', 'elementpress' ),
					'placeholder' => __( 'Enter Your price period', 'elementpress' ),
				]
			);
		//show coupan switcher inside vps slider content section
		$this->add_control(
			'show_coupon',
			[
				'label' => __( 'Show Coupon', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementpress' ),
				'label_off' => __( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		//coupan code text inside vps slider content section
        $this->add_control(
			'coupon_text',
			[
				'label' => __( 'Enter Your (Coupon Code) Custom text', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Coupon Code', 'elementpress' ),
				'placeholder' => __( 'Enter Your (Coupon Code) Custom text', 'elementpress' ),
			]
		);
		//promo code text value inside vps slider content section
        $this->add_control(
			'coupon_code_value',
			[
				'label' => __( 'Promo Code Value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '30% OFF', 'elementpress' ),
				'placeholder' => __( 'Enter Promo Code Value', 'elementpress' ),
			]
        );
        //promo code text  inside vps slider content section
        $this->add_control(
			'coupon_code',
			[
				'label' => __( 'Promo Code', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'LVPS30', 'elementpress' ),
				'placeholder' => __( 'Enter Promo Code', 'elementpress' ),
			]
		);
		//options controls
		//option 1 title control
		$this->add_control(
			'opt1name',
			[
				'label' => __( 'Option 1 Title', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Option 1', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option 1 choose icon control
        $this->add_control(
			'image1url',
			[
				'label' => __( 'Option 1 Icon', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
			//option 2 title control
        $this->add_control(
			'opt2name',
			[
				'label' => __( 'Option 2 Title', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Option 2', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
			//option 2 choose icon control
        $this->add_control(
			'image2url',
			[
				'label' => __( 'Option 2 Icon', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		//option 3 title control
        $this->add_control(
			'opt3name',
			[
				'label' => __( 'Option 3 Title', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Option 3', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
			//option 3 icon control
        $this->add_control(
			'image3url',
			[
				'label' => __( 'Option 3 Icon', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		//option 4 title control
        $this->add_control(
			'opt4name',
			[
				'label' => __( 'Option 1 Title', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Option 1', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option 4 icon control
        $this->add_control(
			'image4url',
			[
				'label' => __( 'Option 1 Icon', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		//Padding min (number control)
		$this->add_control(
			'paddingMin',
			[
				'label' => __( 'Padding Min', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 5,
				'max' => 10000,
				'step' => 5,
				'default' => 50,
			]
		);
		//Max padding control
		$this->add_control(
			'paddingMax',
			[
				'label' => __( 'Padding Max', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 5,
				'max' => 10000,
				'step' => 5,
				'default' => 80,
			]
		);
			//Repeater (things which could be repeated)
		$repeater = new \Elementor\Repeater();
		//plan name text control
        $repeater->add_control(
			'plan_name',
			[
				'label' => __( 'Plan Name', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Plan 1', 'elementpress' ),
				'placeholder' => __( 'Enter Plan Name', 'elementpress' ),
			]
		);
		//plan price text control
        $repeater->add_control(
			'plan_price',
			[
				'label' => __( 'Plan Price', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$89.00', 'elementpress' ),
				'placeholder' => __( 'Enter Plan Price', 'elementpress' ),
			]
		);
        $repeater->add_control(
			'decimal_price',
			[
				'label' => __( 'Decimal Price', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '00', 'elementpress' ),
				'placeholder' => __( 'Enter Post Decimal Price', 'elementpress' ),
			]
		);
		//discount price  text control
		$repeater->add_control(
			'discount_price',
			[
				'label' => __( 'Discount Price', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$69.00', 'elementpress' ),
				'placeholder' => __( 'Enter Discount Price', 'elementpress' ),
			]
        );
		//option1 value text control
        $repeater->add_control(
			'opt1value',
			[
				'label' => __( 'Option 1 value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$53', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option2 value text control
        $repeater->add_control(
			'opt2value',
			[
				'label' => __( 'Option 2 value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$44', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option3 value text control
        $repeater->add_control(
			'opt3value',
			[
				'label' => __( 'Option 3 value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$76', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//option4 value text control
        $repeater->add_control(
			'opt4value',
			[
				'label' => __( 'Option 4 value', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '$98', 'elementpress' ),
				'placeholder' => __( 'Enter Value', 'elementpress' ),
			]
		);
		//Url control
		$repeater->add_control(
			'plan_order_link',
			[
				'label' => __( 'Plan Order Link', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'elementpress' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		//repater control
		$this->add_control(
			'plain_list',
			[
				'label' => __( 'Plain List', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'plan_name' => __('Plan 1', 'elementpress' ),
						'plan_price'=>__('$89.00', 'elementpress' ),
						'discount_price'=>__('$69.00', 'elementpress' ),
						'opt1name'=>__('Option 1', 'elementpress' ),
						'image1url'=>Utils::get_placeholder_image_src(),
						'opt2name'=>__('Option 2', 'elementpress' ),
						'image2url'=>Utils::get_placeholder_image_src(),
						'opt3name'=>__('Option 3', 'elementpress' ),
						'image3url'=>Utils::get_placeholder_image_src(),
						'opt4name'=>__('Option 4', 'elementpress' ),
						'image4url'=>Utils::get_placeholder_image_src(),
						'opt1value'=>__('$','elementpress'),
						'opt2value'=>__('$','elementpress'),
						'opt3value'=>__('$','elementpress'),
						'opt3value'=>__('$','elementpress'),
						'plan_order_link'=>__('https://your-link.com','elementpress'),
					],
				],
				'title_field' => '{{{ plan_name }}}',
			]
		);
		//custom code (code control)
		$this->add_control(
			'custom_css',
			[
				'label' => __( 'Custom Code', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'rows' => 20,
			]
		);
        $this->end_controls_section();

		
		//////////////////////////////////////////////////////////////////////////////////////////////////
		//Container controls
		$this->start_controls_section(
				'container_style',
				[
					'label' => __('Container', 'elementpress' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'content_position',
				[
					'label' => esc_html__( 'Price Position', 'elementor' ),
					'type' => Controls_Manager::CHOOSE,
					'default' => 'left',
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'elementor' ),
							'icon' => 'eicon-h-align-left',
						],
						'top' => [
							'title' => esc_html__( 'Top', 'elementor' ),
							'icon' => 'eicon-v-align-bottom',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'elementor' ),
							'icon' => 'eicon-h-align-right',
						],
					],
					'prefix_class' => 'elementpress-content-position-',
					'toggle' => false,
				]
			);

			$this->add_responsive_control(
				'slider_container',
				[
					'label' => esc_html__( 'Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .slider-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'background',
					'types' => [ 'classic', 'gradient', 'video' ],
					'selector' => '{{WRAPPER}} .slider-container',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'container_border',
					'selector' => '{{WRAPPER}} .slider-container',
				]
			);

			$this->add_responsive_control(
				'container_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .slider-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
		$this->end_controls_section();

		//////////////////////////////////////////////////////////////////////////////////////////////////
		//Slider controls
		$this->start_controls_section(
				'slider_style',
				[
					'label' => __('Slider Style', 'elementpress' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'sliderbox',
				[
					'label' => esc_html__( 'Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .sliderbox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'slider_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .slider_node' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => 'slide_bg',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .slider_node',
				]
			);

			$this->add_control(
				'slider_img',
				[
					'label' => esc_html__( 'Slider Handle Icon', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::MEDIA,
					'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
				]
			);

			
			$this->start_controls_tabs(
				'style_tabs'
			);
				$this->start_controls_tab(
					'style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'textdomain' ),
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'slide_background',
						'label' => esc_html__( 'Slider Icon', 'textdomain' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => '{{WRAPPER}} .slider-container #slider',
					]
				);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_active_tab',
					[
						'label' => esc_html__( 'Active', 'textdomain' ),
					]
				);
				$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'slide_active_background',
						'types' => [ 'classic', 'gradient' ],
						'selector' => '{{WRAPPER}} .slider-container #slider .ui-slider-range',
					]
				);
				$this->end_controls_tab();

			$this->end_controls_tabs();
			
			
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'slider_box_shadow',
					'selector' => '{{WRAPPER}} .slider-container #slider',
				]
			);
			
		$this->end_controls_section();

		//////////////////////////////////////////////////////////////////////////////////////////////////
		//Plans Style Controls
		$this->start_controls_section(
				'plans_style',
				[
					'label' => __('Plans Style', 'elementpress' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
		
			$this->add_control(
				'plans_color',
				[
					'label' => __( 'Color', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .price_rangetxt .icon span' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'plans_typography',
					'selector' => '{{WRAPPER}} .price_rangetxt .icon span',
				]
			);

			$this->add_responsive_control(
				'price_rangetxt',
				[
					'label' => esc_html__( 'Labels Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .price_rangetxt' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			
			$this->add_responsive_control(
				'price_rangetxt_labels',
				[
					'label' => esc_html__( 'Spacing', 'elementor' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
					'default' => [
						'size' => 15,
					],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .price_rangetxt span' => 'padding-right: {{SIZE}}{{UNIT}};',
					],
						
				]
			);

		$this->end_controls_section();
			

		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//Currency Style Controls
		$this->start_controls_section(
			'currency_style',
			[
				'label' => __('Currency Style', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
       	 		);

				$this->add_control(
					'currency_color',
					[
						'label' => __( 'Color', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .price_txt .price_prefix' => 'color: {{VALUE}}',
						],
					]
				);
				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' => 'currency_typography',
						'selector' => '{{WRAPPER}} .price_txt .price_prefix',
					]
				);

				$this->add_responsive_control(
					'currency_space',
					[
						'label' => esc_html__( 'Currency Position', 'elementor' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
						'default' => [
							'size' => 0,
						],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 10,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .price_txt .price_prefix' => 'Top: {{SIZE}}{{UNIT}};',
						],
							
					]
				);
				
				$this->add_responsive_control(
					'currency_margin',
					[
						'label' => esc_html__( 'Margin', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' => [
							'{{WRAPPER}} .price_txt .price_prefix' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

		$this->end_controls_section();


		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//Duration Controls
		$this->start_controls_section(
			'duration_style',
			[
				'label' => __('Duration Style', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
       	 		);

				
				$this->add_responsive_control(
					'duration_space',
					[
						'label' => esc_html__( 'Duration Position', 'elementor' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
						'default' => [
							'size' => 0,
						],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 10,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .price_txt .period_text' => 'Top: {{SIZE}}{{UNIT}};',
						],
							
					]
				);
			
				$this->add_control(
					'duration_color',
					[
						'label' => __( 'Duration Color', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .price_txt .period_text' => 'color: {{VALUE}}',
						],
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' => 'duration_typography',
						'selector' => '{{WRAPPER}} .price_txt .period_text',
					]
				);

				$this->add_responsive_control(
					'duration_margin',
					[
						'label' => esc_html__( 'Margin', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' => [
							'{{WRAPPER}} .price_txt .period_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
				
		$this->end_controls_section();


		///////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//Seperator Controls
		$this->start_controls_section(
			'seperator_style',
			[
				'label' => __('Seperator Style', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
       	 		);

				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' => 'seperator_typography',
						'selector' => '{{WRAPPER}} .price_txt .period_separator',
					]
				);

				$this->add_control(
					'seperator_color',
					[
						'label' => __( 'Seperator Color', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .price_txt .period_separator' => 'color: {{VALUE}}',
						],
					]
				);
				
				
		$this->end_controls_section();
		
		////////////////////////////////////////////////////////////////////////////////////////////
		//Pricing Controls
		$this->start_controls_section(
			'pricing_style',
			[
				'label' => __('Pricing Style', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
       	 		);

				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' => 'pricing_typography',
						'selector' => '{{WRAPPER}} .slider_price_box .price_txt #price_val',
					]
				);

				$this->add_responsive_control(
					'pricing_space',
					[
						'label' => esc_html__( 'Price Position', 'elementor' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
						'default' => [
							'size' => 0,
						],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 10,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .slider_price_box .price_txt #price_val' => 'Top: {{SIZE}}{{UNIT}};',
						],
							
					]
				);

				$this->add_control(
					'pricing_color',
					[
						'label' => __( 'Price Color', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .slider_price_box .price_txt #price_val' => 'color: {{VALUE}}',
						],
					]
				);

				$this->add_responsive_control(
					'decimal_space',
					[
						'label' => esc_html__( 'Decimal Position', 'elementor' ),
						'type' => Controls_Manager::SLIDER,
						'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
						'default' => [
							'size' => 0,
						],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 10,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .slider_price_box .price_txt #decimal_val' => 'Top: {{SIZE}}{{UNIT}};',
						],
							
					]
				);

				$this->add_control(
					'decimal_color',
					[
						'label' => __( 'Decimal Color', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .slider_price_box .price_txt #decimal_val' => 'color: {{VALUE}}',
						],
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Typography::get_type(),
					[
						'name' => 'decimal_typography',
						'selector' => '{{WRAPPER}} .slider_price_box .price_txt #decimal_val',
					]
				);
				$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'slider_price_box_bg',
						'types' => [ 'classic', 'gradient' ],
						'selector' => '{{WRAPPER}} .slider_price_box',
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'slider_price_box_border',
						'selector' => '{{WRAPPER}} .slider_price_box',
					]
				);

				$this->add_responsive_control(
					'slider_price_box_border_radius',
					[
						'label' => esc_html__( 'Border Radius', 'elementor' ),
						'type' => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' => [
							'{{WRAPPER}} .slider_price_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

				$this->add_responsive_control(
					'slider_price_box_padding',
					[
						'label' => esc_html__( 'Padding', 'textdomain' ),
						'type' => \Elementor\Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' => [
							'{{WRAPPER}} .slider_price_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
				
		$this->end_controls_section();

		///////////////////////////////////////////////////////////////////////////////////
		//Options Style Controls
		$this->start_controls_section(
			'options_style',
				[
					'label' => __('Options Style', 'elementpress' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$this->add_responsive_control(
				'options_padding',
				[
					'label' => esc_html__( 'Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .slider_detail .slider-detail-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_control(
				'option_color',
				[
					'label' => __( 'Heading Color', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .inner_price_content .value_text .option_heading' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'heading_typography',
					'selector' => '{{WRAPPER}} .inner_price_content .value_text .option_heading',
				]
			);
			

			$this->add_responsive_control(
				'heading_space',
				[
					'label' => esc_html__( 'Spacing', 'elementor' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
					'default' => [
						'size' => 15,
					],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .inner_price_content .value_text .option_heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
						
				]
			);

			//////////////////      Value controls                  ////////////////////

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'label' => esc_html__( 'Value', 'elementor' ),
					'name' => 'value_typography',
					'selector' => '{{WRAPPER}} .inner_price_content .value_text .value',
				]
			);
			$this->add_control(
				'value_color',
				[
					'label' => __( 'Value Color', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .inner_price_content .value_text .value' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => 'border',
					'selector' => '{{WRAPPER}} .inner_price_content .image_holder img',
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'box_shadow',
					'selector' => '{{WRAPPER}} .inner_price_content .image_holder img',
				]
			);

			$this->add_responsive_control(
				'image_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .inner_price_content .image_holder img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'position',
				[
					'label' => esc_html__( 'Image Position', 'elementor' ),
					'type' => Controls_Manager::CHOOSE,
					'default' => 'left',
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'elementor' ),
							'icon' => 'eicon-h-align-left',
						],
						'top' => [
							'title' => esc_html__( 'Top', 'elementor' ),
							'icon' => 'eicon-v-align-top',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'elementor' ),
							'icon' => 'eicon-h-align-right',
						],
					],
					'prefix_class' => 'elementpress-position-',
					'toggle' => false,
				]
			);
			$this->add_responsive_control(
				'image_padding',
				[
					'label' => esc_html__( 'Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .featured_price_content .image_holder' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
				);

		
		$this->end_controls_section();

		/////////////////////////////////////////////////////////////////////////////////////////////
		//Button Style Control

		$this->start_controls_section(
			'button_style',
				[
					'label' => __('Button Style', 'elementpress' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_responsive_control(
				'order_button_padding',
				[
					'label' => esc_html__( 'Padding', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .slider_price_box .vps_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'order_button_margin',
				[
					'label' => esc_html__( 'Margin', 'textdomain' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .slider_price_box .vps_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);


			
			
			$this->start_controls_tabs(
				'style_order_tabs'
			);
		
				$this->start_controls_tab(
				'style_order_normal_tab',
						[
							'label' => esc_html__( 'Normal', 'textdomain' ),
						]
					);
					$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'background',
						'types' => [ 'classic', 'gradient', 'video' ],
						'selector' => '{{WRAPPER}} .slider_price_box .vps_btn',
					]
					);

					
					$this->add_group_control(
						\Elementor\Group_Control_Background::get_type(),
						[
							'name' => 'button_background',
							'types' => [ 'classic', 'gradient'],
							'selector' => '{{WRAPPER}} .slider_price_box .vps_btn',
						]
					);

					$this->add_group_control(
						\Elementor\Group_Control_Border::get_type(),
						[
							'name' => 'button_border',
							'selector' => '{{WRAPPER}} .slider_price_box .vps_btn',
						]
					);


					$this->add_responsive_control(
						'order_button_border',
						[
							'label' => esc_html__( 'Border Radius', 'elementor' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
							'selectors' => [
								'{{WRAPPER}} .slider_price_box .vps_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_order_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'textdomain' ),
					]
				);
				$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'background',
						'types' => [ 'classic', 'gradient', 'video' ],
						'selector' => '{{WRAPPER}} .slider_price_box .vps_btn:hover',
					]
				);

				
				$this->add_group_control(
					\Elementor\Group_Control_Background::get_type(),
					[
						'name' => 'button_hover_background',
						'types' => [ 'classic', 'gradient'],
						'selector' => '{{WRAPPER}} .slider_price_box .vps_btn:hover',
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'button_hover_border',
						'selector' => '{{WRAPPER}} .slider_price_box .vps_btn:hover',
					]
				);


				$this->add_responsive_control(
					'order_button_hover_border',
					[
						'label' => esc_html__( 'Border Radius', 'elementor' ),
						'type' => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
						'selectors' => [
							'{{WRAPPER}} .slider_price_box .vps_btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);
				$this->end_controls_tab();
			$this->end_controls_tabs();

		$this->end_controls_section();

		///////////////////////////////////////////////////////////////////////////////////
			
		}

		//////////////////////////////////////////////////////////////////////////////////////////////////////////////
		
	//front end rendering
    protected function render() {
		$settings = $this->get_settings_for_display(); //get all the above settings
		//echo 'settings: <pre>' . print_r($settings, true) . '</pre>';
		echo $settings['custom_css'];
		?>
        <section class="padding_bottom_100 padding_top_100 text-center float-left w-100 bg_color_f4f8fa ">
    <div class="container">
        <div class="heading-spacer col-xs-12"></div>
        <div class="slider-container bg_color_fafafa">
			<div class="price_option_outter">
				<div class="price_rangetxt flex-container">
					<?php 
					foreach($settings['plain_list'] as $key=>$item)
					{
						if($key<10)
							{
							?>

							<div id="icon-<?php echo $key?>" class="icon"><span><?=$item['plan_name']?></span></div>

							<?php
							$count=$key+1;
							}
					}
					?>

				
				
					<!--price_rangetxt-->
				</div>
				<div class="slider_node float-left w-100 bg_color_424357 padding_bottom_150">
					<div class="price-slider-section col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12 float-left">
						<div class="sliderbox">
							<div id="slider"></div>
							<!--sliderbox-->
						</div>
						<div class="clear"></div>
					</div>
				</div>
				
				<div class="slider_detail float-left w-100">
					<div class="col-xl-12 col-lg-12 col-md-12 float-left padding_tb_40 border_tb margin_top-170 slider-detail-inner">
					
						<div id="cpu_val" class="col-xl-3 col-lg-3 col-md-3 col-3 float-left featured_price_content">
							<div class="inner_price_content float-left w-100">
								<div class="image_holder float-left w-100"><span><img alt="" src="<?=$settings['image1url']['url']?>"> </span></div>
								<div class="value_text float-left w-100"><p class="option_heading"><?=$settings['opt1name']?></p><br> <span class="value"></span>  </div>
							</div>
							<!--smallbox-->
						</div>
						<div id="ram_val" class="col-xl-3 col-lg-3 col-md-3 col-3 float-left featured_price_content">
							<div class="inner_price_content float-left w-100">
							<div class="image_holder float-left w-100"><span><img alt="" src="<?=$settings['image2url']['url']?>"> </span></div>
							<div class="value_text float-left w-100"><p class="option_heading"><?=$settings['opt2name']?></p><br> <span class="value"></span></div>
							</div>
							<!--smallbox-->
						</div>
						<div id="hdd_val" class="col-xl-3 col-lg-3 col-md-3 col-3 float-left featured_price_content">
							<div class="inner_price_content float-left w-100">
							<div class="image_holder float-left w-100"><span><img alt="" src="<?=$settings['image3url']['url']?>"> </span></div>
							<div class="value_text float-left w-100"><p class="option_heading"><?=$settings['opt3name']?></p><br> <span class="value"></span> </div>
							</div>
							<!--smallbox-->
						</div>
						<div id="bandwidth_val" class="col-xl-3 col-lg-3 col-md-3 col-3 float-left featured_price_content">
							<div class="inner_price_content float-left w-100">
							<div class="image_holder float-left w-100"><span><img alt="" src="<?=$settings['image4url']['url']?>"> </span></div>
							<div class="value_text float-left w-100"><p class="option_heading"><?=$settings['opt4name']?></p><br> <span class="value"></span> </div>
							</div>
							<!--smallbox-->
						</div>
					</div>
				</div>
			</div>
			<div class="col-xl-12 col-lg-12 col-md-12 float-left w-100 slider_price_box">
				<div class="d-inline-block button_outter">
					<div class="price_txt smallbox"><span class="price_prefix"><?=$settings['currency']?></span><span id="price_val" class="numeric1"></span><span id="decimal_val" class="decimal1"></span><span class="period_separator"><?=$settings['period_separator']?></span><span class="period_text"><?=$settings['period_text']?></span></div>
				</div>
				<a href="https://www.your-domain.com/?cmd=cart&amp;action=add&amp;id=250" class="vps_btn buynow-button"><?=$settings['btn_txt']?></a>
				<?php if($settings['show_coupon']=='yes')
				{?>
				<div class="price_offer"><span class="off"><?=$settings['coupon_code_value']?></span> <br><span class='coupon_text'> <?=$settings['coupon_text']?> : </span><span><?=$settings['coupon_code']?></span></div>
				<?php } ?>
				<div class="clear"></div>
            </div>
        </div>
	</div>
	<?php
	$value1= $value2=  $value3= $value4= $pln_price= $pln_order_link= array();
	$slider_img = $settings['slider_img']['url'];

	foreach($settings['plain_list'] as $items)
	{
		$value1[]=$items['opt1value'];
		$value2[]=$items['opt2value'];
		$value3[]=$items['opt3value'];
		$value4[]=$items['opt4value'];
		$pln_price[]=$items['plan_price'];
		$decimal_price[]=$items['decimal_price'];
		$pln_order_link[]=$items['plan_order_link']['url'];
	}
	
	?>
</section>
<script >
var slider_handel_img = "<?= $slider_img ?>";

var cpu_arr = new Array(<?php echo  "'" . implode ( "', '", $value1 ) . "'";?>);
var ram_arr = new Array(<?php echo "'" . implode ( "', '", $value2 ) . "'";?>);
var hdd_arr = new Array(<?php echo "'" . implode ( "', '", $value3 ) . "'";?>);
var bandwidth_arr = new Array(<?php echo "'" . implode ( "', '", $value4 ) . "'";?>);
var ip_arr = new Array('3 IPs', '5 IPs', '7 IPs', '9 IPs', 'Unlimited')
var price_arr = new Array(<?php echo "'" . implode ( "', '", $pln_price ) . "'";?>);
var decimal_arr = new Array(<?php echo "'" . implode ( "', '", $decimal_price ) . "'";?>);
var link_arr = new Array('$10', '$25', '$50', '$75', '$100', '$125');
var b_url = new Array(<?php echo "'" . implode ( "', '", $pln_order_link ) . "'";?>);
var def_pos = <?= $settings['defualt_position'] ?>;

	jQuery(document).ready(function() {

		jQuery("#slider").slider({
        range: 'min',
        animate: true,
        min: 1,
        max: <?php echo $count;?>,
        paddingMin: <?=$settings['paddingMin']?>,
        paddingMax: <?=$settings['paddingMax']?>,
        change: function(event, ui) {
            jQuery('.slider-container #cpu_val span.value').html(cpu_arr[ui.value - 1]);
            jQuery('.slider-container #ram_val span.value').html(ram_arr[ui.value - 1]);
            jQuery('.slider-container #hdd_val span.value').html(hdd_arr[ui.value - 1]);
            jQuery('.slider-container #bandwidth_val span.value').html(bandwidth_arr[ui.value - 1]);
            jQuery('.slider-container #ip_val span.value').html(ip_arr[ui.value - 1]);
            jQuery('.slider-container #price_val').html(price_arr[ui.value - 1]);
            jQuery('.slider-container #decimal_val').html("."+decimal_arr[ui.value - 1]);
            jQuery('.slider-container a.buynow-button').attr('href', b_url[ui.value - 1]);
            jQuery('.slider-container div.price_rangetxt div#icon-' + (ui.value - 1)).addClass("current");
            jQuery('.slider-container #sub-heading-' + (ui.value - 1)).addClass("current1");

        }
    });
    jQuery("#amount").val("$" + jQuery("#slider").slider("value"));
    jQuery('#slider').slider('value', def_pos);
    jQuery('.icon').click(function() {
        ch_value = parseInt(this.id.slice(5)) + 1;
        jQuery(".slider-container div.price_rangetxt div").removeClass("current");
        jQuery(".slider-container .heading div").removeClass("current1");
        jQuery('#slider').slider('value', ch_value);
    });
	if(slider_handel_img != ""){
		jQuery(document).find(".ui-slider-handle").css("background-image", "url(" + slider_handel_img + ")");
	}
	
});



</script>
	<?php
  }
    protected function content_template() { }
}