<?php
/**
 * @author : Jegtheme
 */

namespace EPRESS\Module;

use EPRESS\ShortCodeGenerator;

abstract Class ModuleOptionAbstract {
	protected static $instance;

	protected $options = array();

	public static function getInstance() {
		$class = get_called_class();

		if ( ! isset( self::$instance[ $class ] ) ) {
			self::$instance[ $class ] = new $class();
		}

		return self::$instance[ $class ];
	}

	protected function __construct() {
		$this->setup_hook();
	}

	public function get_options() {
		if ( empty( $this->options ) ) {
			$this->set_options();
		}

		return $this->options;
	}

	public function setup_hook() {
		$shortcode = epress_get_shortcode_name_from_option( get_class( $this ) );
		add_action( 'init', array( $this, 'map_vc' ) );
		add_filter( 'epress_shortcode_elements', array( $this, 'register_shortcode' ) );
		add_action( 'wp_ajax_' . $shortcode, array( $this, 'get_ajax_option' ) );
	}

	public function get_ajax_option() {
		$options  = $this->get_options();
		$segments = ShortCodeGenerator::getInstance()->prepare_segments( $options );
		$fields   = ShortCodeGenerator::getInstance()->prepare_fields( array(), $options );

		wp_send_json_success( array(
			'segments' => $segments,
			'fields'   => $fields,
		) );
	}

	public function remove_description() {
		$options = array();

		foreach ( $this->options as $key => $option ) {
			unset( $option['description'] );
			$options[] = $option;
		}

		return $options;
	}

	public function register_shortcode( $elements ) {
		$id                  = epress_get_shortcode_name_from_option( get_class( $this ) );
		$element             = array();
		$element['name']     = $this->get_module_name();
		$element['category'] = $this->get_category();

		$elements[ $id ] = $element;

		return $elements;
	}

	public function map_vc() {
		if ( class_exists( 'WPBakeryVisualComposerAbstract' ) ) {
			$this->set_options();
			$this->show_compatible_column();

			$vc_options['base']        = epress_get_shortcode_name_from_option( get_class( $this ) );
			$vc_options['params']      = $this->options;
			$vc_options['name']        = $this->get_module_name();
			$vc_options['category']    = $this->get_category();
			$vc_options['icon']        = strtolower( $vc_options['base'] );
			$vc_options['description'] = $this->get_module_name();
			$vc_options['as_parent']   = $this->get_module_parent();
			$vc_options['as_child']    = $this->get_module_child();

			if ( ! empty( $vc_options['as_parent'] ) ) {
				include_once 'modules-container.php';

				$vc_options['js_view'] = 'VcColumnView';
			}

			vc_map( $vc_options );
		}
	}

	public function get_module_parent() {
		return '';
	}

	public function get_module_child() {
		return '';
	}

	public function show_compatible_column() {
		$option_group = isset( $this->options[0]['group'] ) ? $this->options[0]['group'] : "";


		$compatible_column = array(
			'type'        => 'alert',
			'param_name'  => 'compatible_column_notice',
			'heading'     => esc_html__( 'Compatible Column: ', 'elementpress' ) . implode( $this->compatible_column(), ', ' ),
			'description' => esc_html__( 'Please check style / design tab to change Module / Block width and make it fit with your current column width', 'elementpress' ),
			'group'       => $option_group,
			'std'         => 'info'
		);

		array_unshift( $this->options, $compatible_column );
	}

	public function set_content_filter_option( $number = 10, $hide_number_post = false ) {
		$dependency = array(
			'element' => "sort_by",
			'value'   => array(
				'post_type',
				'latest',
				'oldest',
				'alphabet_asc',
				'alphabet_desc',
				'random',
				'random_week',
				'random_month',
				'most_comment',
				'most_comment_day',
				'most_comment_week',
				'most_comment_month',
				'popular_post_jetpack_day',
				'popular_post_jetpack_week',
				'popular_post_jetpack_month',
				'popular_post_jetpack_all',
				'rate',
				'like',
				'share'
			)
		);

		$this->options[] = array(
			'type'        => 'select',
			'param_name'  => 'post_type',
			'heading'     => esc_html__( 'Include Post Type', 'elementpress' ),
			'description' => esc_html__( 'Choose post type for this content.', 'elementpress' ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => 'post',
			'value'       => array_flip( epress_get_enable_post_type() ),
			'dependency'  => $dependency
		);

		if ( ! $hide_number_post ) {
			$this->options[] = array(
				'type'        => 'slider',
				'param_name'  => 'number_post',
				'heading'     => esc_html__( 'Number of Post', 'elementpress' ),
				'description' => esc_html__( 'Show number of post on this module.', 'elementpress' ),
				'group'       => esc_html__( 'Content Filter', 'elementpress' ),
				'min'         => 1,
				'max'         => 30,
				'step'        => 1,
				'std'         => $number,
			);
		}

		if ( $hide_number_post && $number > 0 ) {
			$this->options[] = array(
				'type'        => 'alert',
				'param_name'  => 'content_filter_number_alert',
				'heading'     => esc_html__( 'Number of post', 'elementpress' ),
				'description' => sprintf( esc_html__( 'This module will require you to choose %s number of post.', 'elementpress' ), $number ),
				'group'       => esc_html__( 'Content Filter', 'elementpress' ),
				'std'         => 'info',
			);
		}

		$this->options[] = array(
			'type'        => 'number',
			'param_name'  => 'post_offset',
			'heading'     => esc_html__( 'Post Offset', 'elementpress' ),
			'description' => esc_html__( 'Number of post offset (start of content).', 'elementpress' ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'min'         => 0,
			'max'         => PHP_INT_MAX,
			'step'        => 1,
			'std'         => 0,
			'dependency'  => $dependency
		);

		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'unique_content',
			'heading'     => esc_html__( 'Include into Unique Content Group', 'elementpress' ),
			'description' => esc_html__( 'Choose unique content option, and this module will be included into unique content group. It won\'t duplicate content across the group. Ajax loaded content won\'t affect this unique content feature.', 'elementpress' ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => 'disable',
			'value'       => array(
				esc_html__( 'Disable', 'elementpress' )                  => 'disable',
				esc_html__( 'Unique Content - Group 1', 'elementpress' ) => 'unique1',
				esc_html__( 'Unique Content - Group 2', 'elementpress' ) => 'unique2',
				esc_html__( 'Unique Content - Group 3', 'elementpress' ) => 'unique3',
				esc_html__( 'Unique Content - Group 4', 'elementpress' ) => 'unique4',
				esc_html__( 'Unique Content - Group 5', 'elementpress' ) => 'unique5',
			),
			'dependency'  => $dependency
		);

		$this->options[] = array(
			'type'     => 'select',
			'multiple' => PHP_INT_MAX,
			'ajax'     => 'epress_find_post',
			'options'  => 'epress_get_post_option',
			'nonce'    => wp_create_nonce( 'epress_find_post' ),

			'param_name'  => 'include_post',
			'heading'     => esc_html__( 'Include Post ID', 'elementpress' ),
			'description' => wp_kses( __( "Tips :<br/> - You can search post id by inputing title, clicking search title, and you will have your post id.<br/>- You can also directly insert your post id, and click enter to add it on the list.", 'elementpress' ), wp_kses_allowed_html() ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => '',
			'dependency'  => $dependency
		);

		$this->options[] = array(
			'type'     => 'select',
			'multiple' => PHP_INT_MAX,
			'ajax'     => 'epress_find_post',
			'options'  => 'epress_get_post_option',
			'nonce'    => wp_create_nonce( 'epress_find_post' ),

			'param_name'  => 'exclude_post',
			'heading'     => esc_html__( 'Exclude Post ID', 'elementpress' ),
			'description' => wp_kses( __( "Tips :<br/> - You can search post id by inputing title, clicking search title, and you will have your post id.<br/>- You can also directly insert your post id, and click enter to add it on the list.", 'elementpress' ), wp_kses_allowed_html() ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => '',
			'dependency'  => $dependency
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'epress_find_category',
			'options'     => 'epress_get_category_option',
			'nonce'       => wp_create_nonce( 'epress_find_category' ),
			'param_name'  => 'include_category',
			'heading'     => esc_html__( 'Include Category', 'elementpress' ),
			'description' => esc_html__( 'Choose which category you want to show on this module.', 'elementpress' ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => '',
			'dependency'  => array( 'element' => "post_type", 'value' => "post" ),
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'epress_find_category',
			'options'     => 'epress_get_category_option',
			'nonce'       => wp_create_nonce( 'epress_find_category' ),
			'param_name'  => 'exclude_category',
			'heading'     => esc_html__( 'Exclude Category', 'elementpress' ),
			'description' => esc_html__( 'Choose excluded category for this module.', 'elementpress' ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => '',
			'dependency'  => array( 'element' => "post_type", 'value' => "post" ),
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'epress_find_author',
			'options'     => 'epress_get_author_option',
			'nonce'       => wp_create_nonce( 'epress_find_author' ),
			'param_name'  => 'include_author',
			'heading'     => esc_html__( 'Author', 'elementpress' ),
			'description' => esc_html__( 'Write to search post author.', 'elementpress' ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => '',
			'dependency'  => $dependency
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'epress_find_tag',
			'options'     => 'epress_get_tag_option',
			'nonce'       => wp_create_nonce( 'epress_find_tag' ),
			'param_name'  => 'include_tag',
			'heading'     => esc_html__( 'Include Tags', 'elementpress' ),
			'description' => esc_html__( 'Write to search post tag.', 'elementpress' ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => '',
			'dependency'  => array( 'element' => "post_type", 'value' => "post" ),
		);

		$this->options[] = array(
			'type'        => 'select',
			'multiple'    => PHP_INT_MAX,
			'ajax'        => 'epress_find_tag',
			'options'     => 'epress_get_tag_option',
			'nonce'       => wp_create_nonce( 'epress_find_tag' ),
			'param_name'  => 'exclude_tag',
			'heading'     => esc_html__( 'Exclude Tags', 'elementpress' ),
			'description' => esc_html__( 'Write to search post tag.', 'elementpress' ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => '',
			'dependency'  => array( 'element' => "post_type", 'value' => "post" ),
		);

		$this->set_taxonomy_option();

		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'sort_by',
			'heading'     => esc_html__( 'Sort by', 'elementpress' ),
			'description' =>
				wp_kses( __( "Sort post by this option<br/>* <strong>Jetpack :</strong> Need <strong>Jetpack</strong> plugin & Stat module enabled.<br/>", 'elementpress' ), wp_kses_allowed_html() ),
			'group'       => esc_html__( 'Content Filter', 'elementpress' ),
			'std'         => 'latest',
			'value'       => array(
				esc_html__( 'Latest Post', 'elementpress' )                       => 'latest',
				esc_html__( 'Oldest Post', 'elementpress' )                       => 'oldest',
				esc_html__( 'Alphabet Asc', 'elementpress' )                      => 'alphabet_asc',
				esc_html__( 'Alphabet Desc', 'elementpress' )                     => 'alphabet_desc',
				esc_html__( 'Random Post', 'elementpress' )                       => 'random',
				esc_html__( 'Random Post (7 Days)', 'elementpress' )              => 'random_week',
				esc_html__( 'Random Post (30 Days)', 'elementpress' )             => 'random_month',
				esc_html__( 'Most Comment', 'elementpress' )                      => 'most_comment',
				esc_html__( 'Popular Post (1 Day - Jetpack)', 'elementpress' )    => 'popular_post_jetpack_day',
				esc_html__( 'Popular Post (7 Days - Jetpack)', 'elementpress' )   => 'popular_post_jetpack_week',
				esc_html__( 'Popular Post (30 Days - Jetpack)', 'elementpress' )  => 'popular_post_jetpack_month',
				esc_html__( 'Popular Post (All Time - Jetpack)', 'elementpress' ) => 'popular_post_jetpack_all',
			)
		);
	}

	public function set_style_option() {
		$width = array(
			esc_html__( 'Auto', 'elementpress' ) => 'auto'
		);

		if ( in_array( 4, $this->compatible_column() ) ) {
			$width = array_merge( $width, array(
				esc_html__( '4 Column Design ( 1 Block )', 'elementpress' ) => 4
			) );
		}

		if ( in_array( 8, $this->compatible_column() ) ) {
			$width = array_merge( $width, array(
				esc_html__( '8 Column Design ( 2 Block )', 'elementpress' ) => 8
			) );
		}

		if ( in_array( 12, $this->compatible_column() ) ) {
			$width = array_merge( $width, array(
				esc_html__( '12 Column Design ( 3 Block )', 'elementpress' ) => 12
			) );
		}

		$this->options[] = array(
			'type'        => 'textfield',
			'param_name'  => 'el_id',
			'heading'     => esc_html__( 'Element ID', 'elementpress' ),
			'description' => wp_kses( sprintf( __( 'Enter element ID (Note: make sure it is unique and valid according to <a href="%s">w3c specification</a>).', 'elementpress' ), 'http://www.w3schools.com/tags/att_global_id.asp' ), wp_kses_allowed_html() ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
		);

		$this->options[] = array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => esc_html__( 'Extra class name', 'elementpress' ),
			'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'elementpress' ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
		);

		if ( $this->show_color_scheme() ) {
			$this->options[] = array(
				'type'        => 'dropdown',
				'param_name'  => 'scheme',
				'heading'     => esc_html__( 'Element Color Scheme', 'elementpress' ),
				'description' => esc_html__( 'choose element color scheme for your element ', 'elementpress' ),
				'group'       => esc_html__( 'Design', 'elementpress' ),
				'default'     => 'normal',
				'value'       => array(
					esc_html__( 'Light', 'elementpress' ) => 'normal',
					esc_html__( 'Dark', 'elementpress' )  => 'alt'
				)
			);
		}

		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'column_width',
			'heading'     => esc_html__( 'Block / Column Width', 'elementpress' ),
			'description' => esc_html__( 'Please choose width of column you want to use on this block. 1 Block represents 4 columns.', 'elementpress' ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
			'std'         => 'auto',
			'value'       => $width,
		);

		$this->additional_style();

		$this->options[] = array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => esc_html__( 'CSS Box', 'elementpress' ),
			'group'      => esc_html__( 'Design', 'elementpress' ),
		);
	}

	public function additional_style() {
	}

	public function show_color_scheme() {
		return true;
	}

	public function get_category() {
		return esc_html__( 'epress - Module', 'elementpress' );
	}

	public function set_typography_option( $instance ) {
		return false;
	}

	public function set_taxonomy_option() {

		$taxonomies = \EPRESS\Util\Cache::get_enable_custom_taxonomies();

		foreach ( $taxonomies as $key => $value ) {

			$this->options[] = array(
				'type'        => 'textfield',
				'param_name'  => $key,
				'heading'     => $value['name'],
				'description' => esc_html__( 'Insert ids of ' . strtolower( $value['name'] ) . ' that you want to include as filter and separate them by comma (Ex: 12,34,56).', 'elementpress' ),
				'group'       => esc_html__( 'Content Filter', 'elementpress' ),
				'dependency'  => array( 'element' => 'post_type', 'value' => $value['post_types'] ),
			);
		}
	}

	abstract public function set_options();

	abstract public function get_module_name();

	abstract public function compatible_column();
}
