<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Block;

Class Block_9_Option extends BlockOptionAbstract
{
    protected $default_number_post = 4;
    protected $show_excerpt = false;
    protected $default_ajax_post = 4;

    public function get_module_name()
    {
        return esc_html__('ElementPress - Module 9', 'elementpress');
    }

	public function set_style_option()
	{
		$this->set_boxed_option();
		parent::set_style_option();
	}

	public function set_typography_option( $instance ) {

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_title > a',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Meta Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post meta', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_meta, {{WRAPPER}} .jeg_post_meta .fa, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a:hover, {{WRAPPER}} .jeg_pl_md_card .jeg_post_category a, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a.current, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta .fa, {{WRAPPER}} .jeg_post_category a',
			]
		);
		$instance->add_control(
			'epress_category_switcher',
			[
				'label' => __( 'Category Style', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementpress' ),
				'label_off' => __( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'empty',
			]
        );
        $instance->add_control(
			'epress_category_color',
			[
				'label' => __( 'Category Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        $instance->add_control(
			'epress_category_hover_color',
			[
				'label' => __( 'Category Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        
        $instance->add_control(
			'epress_category_bg_color',
			[
				'label' => __( 'Category Background Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'background: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );

        $instance->add_control(
			'epress_category_bg_hover_color',
			[
				'label' => __( 'Category Background Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'background: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );

        $instance->add_group_control(
		    \Elementor\Group_Control_Typography::get_type(),
		    [
			    'name'        => 'category_typography',
			    'label'       => esc_html__( 'Category Typography', 'elementpress' ),
			    'description' => esc_html__( 'Set typography for post Category', 'elementpress' ),
			    'selector'    => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],    
            ]
        );
        
		$instance->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'epress_cat_border',
				'label' => __( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );
        $instance->add_control(
			'epress_category_border_hover_color',
			[
				'label' => __( 'Category Border Hover Color', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'scheme' => [
					'type' => \Elementor\Core\Schemes\Color::get_type(),
					'value' => \Elementor\Core\Schemes\Color::COLOR_3,
				],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category:hover > a, {{WRAPPER}} .jeg_post_category:hover > span:hover > a' => 'border-color: {{VALUE}}',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],   
			]
        );
        $instance->add_control(
			'epress_category_border_radius',
			[
				'label' => __( 'Category Border Radius', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
        );
        $instance->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => __( 'Box Shadow', 'elementpress' ),
                'selector' => '{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a',
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);

        $instance->add_control(
			'epress_category_margin',
			[
				'label' => __( 'Category Margin', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);
        $instance->add_control(
			'epress_category_padding',
			[
				'label' => __( 'Category Padding', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .jeg_post_category > a, {{WRAPPER}} .jeg_post_category > span > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'   => ['epress_category_switcher' => 'yes'],
			]
		);
        
        $instance->add_responsive_control(
            'epress_image_width',
            [
                'label' => __('Image Resize', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'devices' => ['desktop','tablet','mobile'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .jeg_thumb' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
      
	}
}
