<?php
/**
 * @author : Jegtheme
 */

namespace EPRESS;


use EPRESS\Image\Image;
use EPRESS\Module\ModuleManager;

use EPRESS\Elementor\ModuleElementor;



class Init {

	private static $instance;

	public static function getInstance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	private function __construct() {
		$this->load_helper();
		$this->load_hook();
		$this->load_module();
	}

	protected function load_hook() {
		add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );

		add_filter( 'jeg_customizer_active_callback_option', array( $this, 'active_callback_option' ), 10, 3 );
	}

	

	public function load_plugin_textdomain() {
		load_plugin_textdomain( 'elementpress', false, EPRESS . '/languages/' );
	}

	protected function load_helper() {
		require_once EPRESS_DIR . 'includes/helper.php';
	}

	protected function load_module() {
		if ( ! is_admin() ) {
			FrontendAjax::getInstance();
		}

		Asset::getInstance();
		Image::getInstance();
		ModuleElementor::getInstance();
	}

	public function load_widget_element() {
		RegisterModuleWidget::getInstance();
	}

	public function active_callback_option( $value, $key, $default ) {

		if ( strpos( $key, 'elementpress' ) !== false ) {
			preg_match( "/\[(.*)\]/", $key, $matches );

			if ( $matches[1] ) {
				$value = epress_get_option( $matches[1], $default );
			}
		}

		return $value;
	}
}
