<?php

namespace Elementor;



if ( ! defined( 'ABSPATH' ) ) {

	exit; // Exit if accessed directly.

}



use Elementor\Core\Schemes;



/**

 * elementpress icon box widget.

 *

 * elementpress widget that displays an icon, a headline and a text.

 *

 * @since 1.0.0

 */

class Epress_icon_box extends Widget_Base {



    public function __construct($data = [], $args = null) {

		parent::__construct($data, $args);

        wp_register_style( 'fontawesome-min-css',  \ElementPress::widgets_url() . '/epress-icon-box/assets/fontawesome.min.css', false, \ElementPress::version );

		wp_register_style( 'icon-style',  \ElementPress::widgets_url() . '/epress-icon-box/assets/icon-style.css', false, \ElementPress::version );

		wp_enqueue_style( 'fontawesome-min-css' );

		wp_enqueue_style( 'icon-style' );

		

 

    }





    public function get_style_depends() {

		 

        return [ 'fontawesome-min-css','icon-style' ];

     }

	/**

	 * Get widget name.

	 *

	 * Retrieve icon box widget name.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget name.

	 */

	public function get_name() {

		return 'epress-icon-box';

	}



	/**

	 * Get widget title.
register_controls
	 *

	 * Retrieve icon box widget title.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget title.

	 */

	public function get_title() {

		return __( 'Epress icon Box', 'elementpress' );

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve icon box widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-icon-box';

	}



	/**

	 * Get widget keywords.

	 *

	 * Retrieve the list of keywords the widget belongs to.

	 *

	 * @since 2.1.0

	 * @access public

	 *

	 * @return array Widget keywords.

	 */

	public function get_keywords() {

		return [ 'Epress icon box', 'icon' ];

	}



	/**

	 * Register icon box widget controls.

	 *

	 * Adds different input fields to allow the user to change and customize the widget settings.

	 *

	 * @since 1.0.0

	 * @access protected

	 */

	protected function register_controls() {

		$this->start_controls_section(

			'section_icon',

			[

				'label' => __( 'Icon Box', 'elementpress' ),

			]

		);



		$this->add_control(

			'selected_icon',

			[

				'label' => __( 'Icon', 'elementpress' ),

				'type' => Controls_Manager::ICONS,

				'fa4compatibility' => 'icon',

				'default' => [

					'value' => 'fas fa-star',

					'library' => 'fa-solid',

				],

			]

		);



		$this->add_control(

			'view',

			[

				'label' => __( 'View', 'elementpress' ),

				'type' => Controls_Manager::SELECT,

				'options' => [

					'default' => __( 'Default', 'elementpress' ),

					'stacked' => __( 'Stacked', 'elementpress' ),

					'framed' => __( 'Framed', 'elementpress' ),

				],

				'default' => 'default',

				'prefix_class' => 'elementpress-view-',

			]

		);



		$this->add_control(

			'shape',

			[

				'label' => __( 'Shape', 'elementpress' ),

				'type' => Controls_Manager::SELECT,

				'options' => [

					'circle' => __( 'Circle', 'elementpress' ),

					'square' => __( 'Square', 'elementpress' ),

				],

				'default' => 'circle',

				'condition' => [

					'view!' => 'default',

					'selected_icon[value]!' => '',

				],

				'prefix_class' => 'elementpress-shape-',

			]

		);



		$this->add_control(

			'title_text',

			[

				'label' => __( 'Title & Description', 'elementpress' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'This is the heading', 'elementpress' ),

				'placeholder' => __( 'Enter your title', 'elementpress' ),

				'label_block' => true,

			]

		);

		$this->add_control(

			'title_size',

			[

				'label' => __( 'Title HTML Tag', 'elementpress' ),

				'type' => Controls_Manager::SELECT,

				'options' => [

					'h1' => 'H1',

					'h2' => 'H2',

					'h3' => 'H3',

					'h4' => 'H4',

					'h5' => 'H5',

					'h6' => 'H6',

					'div' => 'div',

					'span' => 'span',

					'p' => 'p',

				],

				'default' => 'h3',

			]

		);



		$this->add_control(

			'description_text',

			[

				'label' => '',

				'type' => Controls_Manager::TEXTAREA,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'elementpress' ),

				'placeholder' => __( 'Enter your description', 'elementpress' ),

				'rows' => 10,

				'separator' => 'none',

				'show_label' => false,

			]

		);



		$this->add_control(

			'link',

			[

				'label' => __( 'Link', 'elementpress' ),

				'type' => Controls_Manager::URL,

				'dynamic' => [

					'active' => true,

				],

				'placeholder' => __( 'https://your-link.com', 'elementpress' ),

				'separator' => 'before',

			]

		);



		$this->add_control(

			'position',

			[

				'label' => __( 'Icon Position', 'elementpress' ),

				'type' => Controls_Manager::CHOOSE,

				'default' => 'top',

				'options' => [

					'left' => [

						'title' => __( 'Left', 'elementpress' ),

						'icon' => 'eicon-h-align-left',

					],

					'top' => [

						'title' => __( 'Top', 'elementpress' ),

						'icon' => 'eicon-v-align-top',

					],

					'right' => [

						'title' => __( 'Right', 'elementpress' ),

						'icon' => 'eicon-h-align-right',

					],

				],

				'prefix_class' => 'epress-position-',

				'toggle' => false,

				'conditions' => [

					'relation' => 'or',

					'terms' => [

						[

							'name' => 'selected_icon[value]',

							'operator' => '!=',

							'value' => '',

						],

					],

				],

			]

		);





		$this->end_controls_section();

///////////////////////////////////// Icon Style Starts Here ////////////////////////////////////////////////

		$this->start_controls_section(

			'section_style_icon',

			[

				'label' => __( 'Icon', 'elementpress' ),

				'tab'   => Controls_Manager::TAB_STYLE,

				'conditions' => [

					'relation' => 'or',

					'terms' => [

						[

							'name' => 'selected_icon[value]',

							'operator' => '!=',

							'value' => '',

						],

					],

				],

			]

		);



		$this->start_controls_tabs( 'icon_colors' );



		$this->start_controls_tab(

			'icon_colors_normal',

			[

				'label' => __( 'Normal', 'elementpress' ),

			]

		);



		$this->add_control(

			'primary_color',

			[

				'label' => __( 'Primary Color', 'elementpress' ),

				'type' => Controls_Manager::COLOR,

				'scheme' => [

					'type' => Schemes\Color::get_type(),

					'value' => Schemes\Color::COLOR_1,

				],

				'default' => '',

				'selectors' => [

					'{{WRAPPER}}.elementpress-view-stacked .elementpress-icon, {{WRAPPER}}.elementpress-view-stacked .elementpress-icon a, {{WRAPPER}} .epress-icon, {{WRAPPER}} .epress-icon a' => 'background-color: {{VALUE}};',

					'{{WRAPPER}}.elementpress-view-framed, {{WRAPPER}}.elementpress-view-framed a, {{WRAPPER}}.elementpress-view-default,  {{WRAPPER}}.elementpress-view-default a' => 'fill: {{VALUE}}; color: {{VALUE}}; border-color: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'secondary_color',

			[

				'label' => __( 'Secondary Color', 'elementpress' ),

				'type' => Controls_Manager::COLOR,

				'default' => '',

				'condition' => [

					'view!' => 'default',

				],

				'selectors' => [

					'{{WRAPPER}}.elementpress-view-framed .elementpress-icon, {{WRAPPER}}.elementpress-view-framed .elementpress-icon a,' => 'background-color: {{VALUE}};',

					'{{WRAPPER}}.elementpress-view-stacked .elementpress-icon, {{WRAPPER}}.elementpress-view-stacked .elementpress-icon a' => 'fill: {{VALUE}}; color: {{VALUE}};',

				],

			]

		);



		$this->end_controls_tab();



		$this->start_controls_tab(

			'icon_colors_hover',

			[

				'label' => __( 'Hover', 'elementpress' ),

			]

		);



		$this->add_control(

			'hover_primary_color',

			[

				'label' => __( 'Primary Color', 'elementpress' ),

				'type' => Controls_Manager::COLOR,

				'default' => '',

				'selectors' => [

					' {{WRAPPER}} .elementpress-icon:hover, {{WRAPPER}} .epress-icon:hover,  {{WRAPPER}} .elementpress-icon:hover, {{WRAPPER}} .epress-icon:hover a' => 'background-color: {{VALUE}};',

					' {{WRAPPER}} .elementpress-icon:hover, {{WRAPPER}} .epress-icon:hover,  {{WRAPPER}} .elementpress-icon:hover, {{WRAPPER}} .epress-icon:hover a' => 'fill: {{VALUE}}; color: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'hover_secondary_color',

			[

				'label' => __( 'Secondary Color', 'elementpress' ),

				'type' => Controls_Manager::COLOR,

				'default' => '',

				'condition' => [

					'view!' => 'default',

				],

				'selectors' => [

					' {{WRAPPER}} .elementpress-icon:hover, {{WRAPPER}} .epress-icon:hover, {{WRAPPER}} .elementpress-icon:hover, {{WRAPPER}} .epress-icon:hover a' => 'background-color: {{VALUE}};',

					' {{WRAPPER}} .elementpress-icon:hover, {{WRAPPER}} .epress-icon:hover, {{WRAPPER}} .elementpress-icon:hover, {{WRAPPER}} .epress-icon:hover a' => 'fill: {{VALUE}}; color: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'hover_animation',

			[

				'label' => __( 'Hover Animation', 'elementpress' ),

				'type' => Controls_Manager::HOVER_ANIMATION,

			]

		);

		



		$this->end_controls_tab();



		$this->end_controls_tabs();



		$this->add_responsive_control(

			'icon_size',

			[

				'label' => __( 'Size', 'elementpress' ),

				'type' => Controls_Manager::SLIDER,

				'range' => [

					'px' => [

						'min' => 6,

						'max' => 300,

					],

				],

				'selectors' => [

					'{{WRAPPER}} .elementpress-icon, {{WRAPPER}} .epress-icon' => 'font-size: {{SIZE}}{{UNIT}};',

				],

			]

		);



		$this->add_control(

			'icon_padding',

			[

				'label' => __( 'Padding', 'elementpress' ),

				'type' => Controls_Manager::SLIDER,

				'selectors' => [

					'{{WRAPPER}} .elementpress-icon, {{WRAPPER}} .epress-icon' => 'padding: {{SIZE}}{{UNIT}};',

				],

				'range' => [

					'em' => [

						'min' => 0,

						'max' => 5,

					],

				],

				'condition' => [

					'view!' => 'default',

				],

			]

		);



		$this->add_control(

			'rotate',

			[

				'label' => __( 'Rotate', 'elementpress' ),

				'type' => Controls_Manager::SLIDER,

				'default' => [

					'size' => 0,

					'unit' => 'deg',

				],

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-icon i, {{WRAPPER}} .elementpress-icon, {{WRAPPER}} .epress-icon i' => 'transform: rotate({{SIZE}}{{UNIT}});',

				],

			]

		);



		$this->add_control(

			'border_width',

			[

				'label' => __( 'Border Width', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'selectors' => [

					'{{WRAPPER}} .elementpress-icon, {{WRAPPER}} .epress-icon' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

				'condition' => [

					'view' => 'framed',

				],

			]

		);

		



		$this->add_control(

			'border_radius',

			[

				'label' => __( 'Border Radius', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', '%' ],

				'selectors' => [

					'{{WRAPPER}} .elementpress-icon, {{WRAPPER}} .epress-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

				'condition' => [

					'view!' => 'default',

				],

			]

		);





		$this->add_group_control(

			Group_Control_Background::get_type(),

			[

				'name' => 'background',

				'label' => __( 'Background', 'elementpress' ),

				'types' => [ 'classic', 'gradient', 'video' ],

				'selector' => '{{WRAPPER}} .epress-icon-box-icon, {{WRAPPER}} .epress-icon',

			]

		);



		$this->add_group_control(

			Group_Control_Border::get_type(),

			[

				'name' => 'epress_icon_border',

				'label' => __( 'Icon Border', 'elementpress' ),

				'selector' => '{{WRAPPER}} .epress-icon-box-icon, {{WRAPPER}} .epress-icon',

			]

		);



		$this->add_control(

			'epress_icon_box_border_radius',

			[

				'label' => __( 'Border Radius', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', '%' ],

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-icon, {{WRAPPER}} .epress-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		);

		$this->add_responsive_control(

            'epress_icon_width',

            [

                'label' => __('Icon Width', 'elementpress'),

                'type' => Controls_Manager::SLIDER,

                'size_units' => ['px', '%'],

                'devices' => ['desktop','tablet','mobile'],

                'range' => [

                    'px' => [

                        'min' => 0,

                        'max' => 1000,

                        'step' => 5,

                    ],

                    '%' => [

                        'min' => 0,

                        'max' => 100,

                    ],

                ],

                'selectors' => [

                    '{{WRAPPER}} .epress-icon-box-icon' => 'width: {{SIZE}}{{UNIT}};',

                ],

            ]

		);

		$this->add_responsive_control(

            'epress_icon_height',

            [

                'label' => __('Icon Height', 'elementpress'),

                'type' => Controls_Manager::SLIDER,

                'size_units' => ['px', '%'],

                'devices' => ['desktop','tablet','mobile'],

                'range' => [

                    'px' => [

                        'min' => 0,

                        'max' => 1000,

                        'step' => 5,

                    ],

                    '%' => [

                        'min' => 0,

                        'max' => 100,

                    ],

                ],

                'selectors' => [

                    '{{WRAPPER}} .epress-icon-box-icon, {{WRAPPER}} .epress-icon' => 'height: {{SIZE}}{{UNIT}};',

                ],

            ]

        );

		$this->end_controls_section();

///////////////////////////////////// Icon Style ends Here ////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////////////////////////////////



///////////////////////////////////// Content Style Starts Here ////////////////////////////////////////////////



		$this->start_controls_section(

			'section_style_content',

			[

				'label' => __( 'Content', 'elementpress' ),

				'tab'   => Controls_Manager::TAB_STYLE,

			]

		);



		$this->add_responsive_control(

			'text_align',

			[

				'label' => __( 'Alignment', 'elementpress' ),

				'type' => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => __( 'Left', 'elementpress' ),

						'icon' => 'eicon-text-align-left',

					],

					'center' => [

						'title' => __( 'Center', 'elementpress' ),

						'icon' => 'eicon-text-align-center',

					],

					'right' => [

						'title' => __( 'Right', 'elementpress' ),

						'icon' => 'eicon-text-align-right',

					],

					'justify' => [

						'title' => __( 'Justified', 'elementpress' ),

						'icon' => 'eicon-text-align-justify',

					],

				],

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-content' => 'text-align: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'content_vertical_alignment',

			[

				'label' => __( 'Vertical Alignment', 'elementpress' ),

				'type' => Controls_Manager::SELECT,

				'options' => [

					'top' => __( 'Top', 'elementpress' ),

					'middle' => __( 'Middle', 'elementpress' ),

					'bottom' => __( 'Bottom', 'elementpress' ),

				],

				'default' => 'top',

				'prefix_class' => 'elementpress-vertical-align-',

			]

		);

		$this->add_responsive_control(

			'epress_content_box_margin',

			[

				'label' => __( 'Margin', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-content' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		);

		

		$this->add_control(

			'heading_title',

			[

				'label' => __( 'Title', 'elementpress' ),

				'type' => Controls_Manager::HEADING,

				'separator' => 'before',

			]

		);

		





		$this->add_responsive_control(

			'title_bottom_space',

			[

				'label' => __( 'Spacing', 'elementpress' ),

				'type' => Controls_Manager::SLIDER,

				'range' => [

					'px' => [

						'min' => 0,

						'max' => 100,

					],

				],

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],

			]

		);



		$this->add_control(

			'title_color',

			[

				'label' => __( 'Title Color', 'elementpress' ),

				'type' => Controls_Manager::COLOR,

				'default' => '',

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-content .epress-icon-box-title,  {{WRAPPER}} .epress-icon-box-content .epress-icon-box-title a' => 'color: {{VALUE}};',

				],

				'scheme' => [

					'type' => Schemes\Color::get_type(),

					'value' => Schemes\Color::COLOR_1,

				],

			]

		);

		$this->add_control(

			'title_hover_color',

			[

				'label' => __( 'Title Hover Color', 'elementpress' ),

				'type' => Controls_Manager::COLOR,

				'default' => '',

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-content .epress-icon-box-title:hover,  {{WRAPPER}} .epress-icon-box-content .epress-icon-box-title:hover a' => 'color: {{VALUE}};',

				],

				'scheme' => [

					'type' => Schemes\Color::get_type(),

					'value' => Schemes\Color::COLOR_1,

				],

			]

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'title_typography',

				'selector' => '{{WRAPPER}} .epress-icon-box-content .epress-icon-box-title',

				'scheme' => Schemes\Typography::TYPOGRAPHY_1,

			]

		);

		$this->add_control(

			'epress_title_margin',

			[

				'label' => __( 'Title Margin', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', '%', 'em' ],

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-content .epress-icon-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

		);

		$this->add_control(

			'heading_description',

			[

				'label' => __( 'Description', 'elementpress' ),

				'type' => Controls_Manager::HEADING,

				'separator' => 'before',

			]

		);

	



		$this->add_control(

			'text_description_color',

			[

				'label' => __( 'Color', 'elementpress' ),

				'type' => Controls_Manager::COLOR,

				'default' => '',

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-content .epress-icon-box-description,{{WRAPPER}} .epress-icon-box-content .epress-icon-box-desc' => 'color: {{VALUE}};',

				],

				'scheme' => [

					'type' => Schemes\Color::get_type(),

					'value' => Schemes\Color::COLOR_3,

				],

			]

		);

		

		$this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'description_typography',

				'selector' => '{{WRAPPER}} .epress-icon-box-content .epress-icon-box-description,{{WRAPPER}} .epress-icon-box-content .epress-icon-box-desc',

				'scheme' => Schemes\Typography::TYPOGRAPHY_3,

			]

		);

		$this->add_control(

			'epress_desc_margin',

			[

				'label' => __( 'Description Margin', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', '%', 'em' ],

				'selectors' => [

					'{{WRAPPER}} .epress-icon-box-content .epress-icon-box-description,{{WRAPPER}} .epress-icon-box-content .epress-icon-box-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],

            ]

		);

		$this->end_controls_section();

	}

///////////////////////////////////// Content Style Ends Here ////////////////////////////////////////////////

	/**

	 * Render icon box widget output on the frontend.

	 *

	 * Written in PHP and used to generate the final HTML.

	 *

	 * @since 1.0.0

	 * @access protected

	 */

	protected function render() {

		$settings = $this->get_settings_for_display();



		$this->add_render_attribute( 'icon', 'class', [ 'elementpress-icon', 'elementpress-animation-' . $settings['hover_animation'] ] );



		$icon_tag = 'span';



		if ( ! isset( $settings['icon'] ) && ! Icons_Manager::is_migration_allowed() ) {

			// add old default

			$settings['icon'] = 'fa fa-star';

		}



		$has_icon = ! empty( $settings['icon'] );



		if ( ! empty( $settings['link']['url'] ) ) {

			$this->add_render_attribute( 'link', 'href', $settings['link']['url'] );

			$icon_tag = 'a';



			if ( $settings['link']['is_external'] ) {

				$this->add_render_attribute( 'link', 'target', '_blank' );

			}



			if ( $settings['link']['nofollow'] ) {

				$this->add_render_attribute( 'link', 'rel', 'nofollow' );

			}

		}



		if ( $has_icon ) {

			$this->add_render_attribute( 'i', 'class', $settings['icon'] );

			$this->add_render_attribute( 'i', 'aria-hidden', 'true' );

		}



		$icon_attributes = $this->get_render_attribute_string( 'icon' );

		$link_attributes = $this->get_render_attribute_string( 'link' );



		$this->add_render_attribute( 'description_text', 'class', 'elementpress-icon-box-description' );



		$this->add_inline_editing_attributes( 'title_text', 'none' );

		$this->add_inline_editing_attributes( 'description_text' );

		if ( ! $has_icon && ! empty( $settings['selected_icon']['value'] ) ) {

			$has_icon = true;

		}

		$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );

		$is_new = ! isset( $settings['icon'] ) && Icons_Manager::is_migration_allowed();

		?>

		<div class="epress-icon-box-wrapper">

			<?php if ( $has_icon ) : ?>

			<div class="epress-icon-box-icon">

				<<?php echo implode( ' ', [ $icon_tag, $icon_attributes, $link_attributes ] ); ?>>

				<?php

				if ( $is_new || $migrated ) {

					Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );

				} elseif ( ! empty( $settings['icon'] ) ) {

					?><span <?php echo $this->get_render_attribute_string( 'i' ); ?>></span><?php

				}

				?>

				</<?php echo $icon_tag; ?>>

			</div>

			<?php endif; ?>

			<div class="epress-icon-box-content">

				<<?php echo $settings['title_size']; ?> class="epress-icon-box-title">

					<<?php echo implode( ' ', [ $icon_tag, $link_attributes ] ); ?><?php echo $this->get_render_attribute_string( 'title_text' ); ?>><?php echo $settings['title_text']; ?></<?php echo $icon_tag; ?>>

				</<?php echo $settings['title_size']; ?>>

				<?php if ( ! Utils::is_empty( $settings['description_text'] ) ) : ?>

				<p class="epress-icon-box-desc"><?php echo $settings['description_text']; ?></p>

				<?php endif; ?>

			</div>

		</div>

		<?php

	}

   /**

	 * Render icon box widget output in the editor.

	 *

	 * Written as a Backbone JavaScript template and used to generate the live preview.

	 *

	 * @since 2.9.0

	 * @access protected

	 */

	protected function content_template() {

		?>

		<#

		var link = settings.link.url ? 'href="' + settings.link.url + '"' : '',

			iconTag = link ? 'a' : 'span',

			iconHTML = elementor.helpers.renderIcon( view, settings.selected_icon, { 'aria-hidden': true }, 'i' , 'object' ),

			migrated = elementor.helpers.isIconMigrated( settings, 'selected_icon' );



		view.addRenderAttribute( 'description_text', 'class', 'epress-icon-box-description' );



		view.addInlineEditingAttributes( 'title_text', 'none' );

		view.addInlineEditingAttributes( 'description_text' );

		#>

		<div class="epress-icon-box-wrapper">

			<# if ( settings.icon || settings.selected_icon ) { #>

			<div class="epress-icon-box-icon">

				<{{{ iconTag + ' ' + link }}} class="epress-icon epress-animation-{{ settings.hover_animation }}">

					<# if ( iconHTML && iconHTML.rendered && ( ! settings.icon || migrated ) ) { #>

						{{{ iconHTML.value }}}

						<# } else { #>

							<i class="{{ settings.icon }}" aria-hidden="true"></i>

						<# } #>

				</{{{ iconTag }}}>

			</div>

			<# } #>

			<div class="epress-icon-box-content">

				<{{{ settings.title_size }}} class="epress-icon-box-title">

					<{{{ iconTag + ' ' + link }}} {{{ view.getRenderAttributeString( 'title_text' ) }}}>{{{ settings.title_text }}}</{{{ iconTag }}}>

				</{{{ settings.title_size }}}>

				<# if ( settings.description_text ) { #>

				<p {{{ view.getRenderAttributeString( 'description_text' ) }}}>{{{ settings.description_text }}}</p>

				<# } #>

			</div>

		</div>

		<?php

	}



	public function on_import( $element ) {

		return Icons_Manager::on_import_migration( $element, 'icon', 'selected_icon', true );

	}

}

